/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.item.battery;

import java.util.List;
import me.luligabi.coxinhautilities.common.item.ComponentRegistry;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import me.luligabi.coxinhautilities.common.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PotatoBatteryItem
extends Item
implements IWittyComment {
    public final int capacity;

    public PotatoBatteryItem(Item.Properties settings) {
        this(settings, 4096);
    }

    public PotatoBatteryItem(Item.Properties settings, int capacity) {
        super(settings.component(ComponentRegistry.ENERGY.get(), (Object)0).component(ComponentRegistry.ENABLED.get(), (Object)false));
        this.capacity = capacity;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide()) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        if (user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            boolean isEnabled = (Boolean)stack.getOrDefault(ComponentRegistry.ENABLED.get(), (Object)false);
            DataComponentPatch changes = DataComponentPatch.builder().set(ComponentRegistry.ENABLED.get(), (Object)(!isEnabled ? 1 : 0)).build();
            stack.applyComponentsAndValidate(changes);
            ((ServerPlayer)user).connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)(isEnabled ? SoundEvents.IRON_TRAPDOOR_CLOSE : SoundEvents.IRON_TRAPDOOR_OPEN)), SoundSource.PLAYERS, user.getX(), user.getY(), user.getZ(), 1.0f, 1.0f, user.blockPosition().asLong()));
            user.displayClientMessage((Component)Component.translatable((String)"tooltip.coxinhautilities.potato_battery.3").withStyle(this.getPrimaryColor()).append((Component)CommonComponents.optionStatus((!isEnabled ? 1 : 0) != 0).copy().withStyle(this.getSecondaryColor())), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, user, hand);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide() || !(entity instanceof Player)) {
            return;
        }
        if (!((Boolean)stack.getOrDefault(ComponentRegistry.ENABLED.get(), (Object)false)).booleanValue()) {
            return;
        }
        Util.distributePowerToInventory((Player)entity, stack, this.getEnergyStorage(stack).getMaxExtract(), predicateStack -> !(predicateStack.getItem() instanceof PotatoBatteryItem));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        this.appendPowerInfo(tooltip, stack);
        this.addWittyComment(tooltip);
    }

    protected void appendPowerInfo(List<Component> tooltip, ItemStack stack) {
        PotatoBatteryEnergyStorage energyStorage = this.getEnergyStorage(stack);
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.potato_battery.1").withStyle(this.getPrimaryColor()).append((Component)Component.translatable((String)"tooltip.coxinhautilities.potato_battery.2", (Object[])new Object[]{Util.formatAccordingToLanguage().format(energyStorage.getEnergyStored()), Util.formatAccordingToLanguage().format(energyStorage.getMaxEnergyStored())}).withStyle(this.getSecondaryColor())));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.potato_battery.3").withStyle(this.getPrimaryColor()).append((Component)CommonComponents.optionStatus((boolean)((Boolean)stack.getOrDefault(ComponentRegistry.ENABLED.get(), (Object)false))).copy().withStyle(this.getSecondaryColor())));
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.potato_battery.witty"));
    }

    protected ChatFormatting getPrimaryColor() {
        return ChatFormatting.YELLOW;
    }

    protected ChatFormatting getSecondaryColor() {
        return ChatFormatting.YELLOW;
    }

    private PotatoBatteryEnergyStorage getEnergyStorage(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage instanceof PotatoBatteryEnergyStorage) {
            PotatoBatteryEnergyStorage potatoEnergyStorage = (PotatoBatteryEnergyStorage)energyStorage;
            return potatoEnergyStorage;
        }
        return null;
    }

    public static class PotatoBatteryEnergyStorage
    extends ComponentEnergyStorage {
        public PotatoBatteryEnergyStorage(MutableDataComponentHolder parent, int capacity) {
            super(parent, ComponentRegistry.ENERGY.get(), capacity, capacity);
        }

        public int getMaxReceive() {
            return this.maxReceive;
        }

        public int getMaxExtract() {
            return this.maxExtract;
        }
    }
}

