/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.luligabi.coxinhautilities.common.block.tank.PortableTankBlockEntity;
import me.luligabi.coxinhautilities.common.block.tank.TankTier;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import me.luligabi.coxinhautilities.common.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class PortableTankBlock
extends BaseEntityBlock
implements IWittyComment {
    private final TankTier tankTier;
    private static final VoxelShape BOUNDING_SHAPE = Block.box((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)16.0, (double)13.5);

    public PortableTankBlock(TankTier tankTier) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL));
        this.tankTier = tankTier;
    }

    protected MapCodec<? extends PortableTankBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TankTier.CODEC.fieldOf("tier").forGetter(PortableTankBlock::getTankTier)).apply((Applicative)instance, PortableTankBlock::new));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (((PortableTankBlockEntity)world.getBlockEntity(pos)).fluidIo(player, player.getUsedItemHand())) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PortableTankBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        boolean hasData = stack.get(DataComponents.BLOCK_ENTITY_DATA) != null;
        CompoundTag data = Util.getBlockEntityData(stack);
        FluidStack fluid = Util.getFluidFromNbt(data);
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.tank.fluidVariant.1").withStyle(this.tankTier.getPrimaryColor()).append((Component)(!hasData || fluid.isEmpty() ? Component.translatable((String)"tooltip.coxinhautilities.tank.none").withStyle(this.tankTier.getSecondaryColor()) : Component.translatable((String)"tooltip.coxinhautilities.tank.fluidVariant.2", (Object[])new Object[]{fluid.getHoverName()}).withStyle(this.tankTier.getSecondaryColor()))));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.tank.capacity.1").withStyle(this.tankTier.getPrimaryColor()).append((Component)Component.translatable((String)"tooltip.coxinhautilities.tank.capacity.2", (Object[])new Object[]{!hasData ? "0" : String.valueOf(fluid.getAmount()), this.tankTier.getCapacity()}).withStyle(this.tankTier.getSecondaryColor())));
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.tank.witty.1"), Component.translatable((String)"tooltip.coxinhautilities.tank.witty.2"));
    }

    public TankTier getTankTier() {
        return this.tankTier;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void saveNbtToStack(BlockEntity blockEntity, ItemStack stack) {
        PortableTankBlockEntity tank;
        if (blockEntity instanceof PortableTankBlockEntity && (tank = (PortableTankBlockEntity)blockEntity).hasWrittenNbt()) {
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tank.saveWithoutMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess())));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOUNDING_SHAPE;
    }
}

