/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.sponge;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import me.luligabi.coxinhautilities.common.block.BlockRegistry;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;

public class LavaSpongeBlock
extends SpongeBlock
implements IWittyComment {
    public LavaSpongeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPONGE).mapColor(MapColor.FIRE));
    }

    protected void tryAbsorbWater(Level world, BlockPos pos) {
        if (!this.canAbsorb(world, pos)) {
            return;
        }
        world.setBlock(pos, BlockRegistry.WET_LAVA_SPONGE.get().defaultBlockState(), 2);
        world.levelEvent(2001, pos, Block.getId((BlockState)Blocks.LAVA.defaultBlockState()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.lava_sponge.witty"));
    }

    private boolean canAbsorb(Level world, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Direction[] var8;
            Tuple pair = (Tuple)queue.poll();
            BlockPos blockPos = (BlockPos)pair.getA();
            int j = (Integer)pair.getB();
            for (Direction direction : var8 = Direction.values()) {
                BlockPos blockPos2 = blockPos.relative(direction);
                BlockState blockState = world.getBlockState(blockPos2);
                FluidState fluidState = world.getFluidState(blockPos2);
                if (!fluidState.is(FluidTags.LAVA)) continue;
                if (blockState.getBlock() instanceof BucketPickup && !((BucketPickup)blockState.getBlock()).pickupBlock(null, (LevelAccessor)world, blockPos2, blockState).isEmpty()) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
                    continue;
                }
                if (!(blockState.getBlock() instanceof LiquidBlock)) continue;
                world.setBlock(blockPos2, Blocks.AIR.defaultBlockState(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

