/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.sink;

import com.mojang.serialization.MapCodec;
import java.util.List;
import me.luligabi.coxinhautilities.common.block.sink.GrannysSinkBlockEntity;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GrannysSinkBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IWittyComment {
    private static final VoxelShape NORTH_VOXELSHAPE = Block.box((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)14.0, (double)15.25);
    private static final VoxelShape SOUTH_VOXELSHAPE = Block.box((double)0.0, (double)0.0, (double)0.75, (double)16.0, (double)14.0, (double)15.5);
    private static final VoxelShape WEST_VOXELSHAPE = Block.box((double)0.5, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape EAST_VOXELSHAPE = Block.box((double)0.75, (double)0.0, (double)0.0, (double)15.5, (double)14.0, (double)16.0);

    public GrannysSinkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return GrannysSinkBlock.simpleCodec(GrannysSinkBlock::new);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (((GrannysSinkBlockEntity)world.getBlockEntity(pos)).fluidIo(player, player.getUsedItemHand())) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrannysSinkBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.1").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.3").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.4").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.5").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.grannys_sink.witty"));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_VOXELSHAPE;
            case Direction.SOUTH -> SOUTH_VOXELSHAPE;
            case Direction.WEST -> WEST_VOXELSHAPE;
            case Direction.EAST -> EAST_VOXELSHAPE;
            default -> Shapes.empty();
        };
    }
}

