/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.misc;

import java.util.List;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CopperLadderBlock
extends LadderBlock
implements WeatheringCopper,
IWittyComment {
    private WeatheringCopper.WeatherState oxidationLevel = WeatheringCopper.WeatherState.UNAFFECTED;
    private boolean canOxidate = false;

    public CopperLadderBlock(WeatheringCopper.WeatherState oxidationLevel) {
        this();
        this.oxidationLevel = oxidationLevel;
        this.canOxidate = true;
    }

    public CopperLadderBlock() {
        super(BlockBehaviour.Properties.of().strength(0.4f).sound(SoundType.COPPER).noOcclusion());
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!this.canOxidate) {
            return;
        }
        this.changeOverTime(state, world, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.canOxidate && WeatheringCopper.getNext((Block)state.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.oxidationLevel;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.copper_ladder.1").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.copper_ladder.2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.copper_ladder.witty.1"), Component.translatable((String)"tooltip.coxinhautilities.copper_ladder.witty.2"));
    }
}

