/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.dryingrack;

import java.util.Optional;
import me.luligabi.coxinhautilities.common.block.BlockEntityRegistry;
import me.luligabi.coxinhautilities.common.block.ClientSyncedBlockEntity;
import me.luligabi.coxinhautilities.common.block.dryingrack.DryingRackInventory;
import me.luligabi.coxinhautilities.common.recipe.drying.DryingRecipe;
import me.luligabi.coxinhautilities.common.recipe.drying.DryingRecipeType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class DryingRackBlockEntity
extends ClientSyncedBlockEntity {
    int dryingTime;
    boolean checkedRecipe;
    boolean canDry;
    public final DryingRackInventory inventory = new DryingRackInventory(this);
    public final InvWrapper invWrapper = new InvWrapper((Container)this.inventory);

    public DryingRackBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.DRYING_RACK.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DryingRackBlockEntity blockEntity) {
        if (blockEntity.inventory.isEmpty()) {
            return;
        }
        if (!blockEntity.checkedRecipe) {
            DryingRackBlockEntity.checkRecipe(blockEntity, world);
        }
        if (blockEntity.canDry) {
            ++blockEntity.dryingTime;
            DryingRackBlockEntity.craft(world, blockEntity);
            DryingRackBlockEntity.setChanged(world, blockEntity.worldPosition, blockEntity.getBlockState());
        }
    }

    private static void checkRecipe(DryingRackBlockEntity blockEntity, Level world) {
        Optional<RecipeHolder<DryingRecipe>> recipeOptional = DryingRackBlockEntity.createRecipeOptional(blockEntity, (ServerLevel)world);
        if (recipeOptional.isEmpty()) {
            return;
        }
        blockEntity.checkedRecipe = true;
        blockEntity.canDry = ((DryingRecipe)recipeOptional.get().value()).getIngredient().test(blockEntity.inventory.getItem(0));
        DryingRackBlockEntity.setChanged(world, blockEntity.worldPosition, blockEntity.getBlockState());
    }

    private static void craft(Level world, DryingRackBlockEntity blockEntity) {
        Optional<RecipeHolder<DryingRecipe>> recipeOptional = DryingRackBlockEntity.createRecipeOptional(blockEntity, (ServerLevel)world);
        if (recipeOptional.isEmpty() || blockEntity.dryingTime < ((DryingRecipe)recipeOptional.get().value()).getDryingTime()) {
            return;
        }
        blockEntity.inventory.setItem(0, ((DryingRecipe)recipeOptional.get().value()).getResultItem((HolderLookup.Provider)world.registryAccess()));
        blockEntity.canDry = false;
        blockEntity.checkedRecipe = false;
        blockEntity.dryingTime = 0;
        DryingRackBlockEntity.setChanged(world, blockEntity.worldPosition, blockEntity.getBlockState());
    }

    @Override
    public void toTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)registryLookup);
        nbt.putShort("DryingTime", (short)this.dryingTime);
        nbt.putBoolean("CheckedRecipe", this.checkedRecipe);
        nbt.putBoolean("CanDry", this.canDry);
    }

    @Override
    public void fromTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.inventory.clearContent();
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)registryLookup);
        this.dryingTime = nbt.getShort("DryingTime");
        this.checkedRecipe = nbt.getBoolean("CheckedRecipe");
        this.canDry = nbt.getBoolean("CanDry");
    }

    @Override
    public void toClientTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)registryLookup);
    }

    @Override
    public void fromClientTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.inventory.clearContent();
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)registryLookup);
    }

    public ItemStack getStack() {
        return this.inventory.getItem(0);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.isClientSide()) {
            this.sync();
        }
    }

    protected static void setChanged(Level world, BlockPos pos, BlockState state) {
        world.blockEntityChanged(pos);
        if (!state.isAir()) {
            world.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        if (!((DryingRackBlockEntity)world.getBlockEntity(pos)).isClientSide()) {
            ((DryingRackBlockEntity)world.getBlockEntity(pos)).sync();
        }
    }

    private static Optional<RecipeHolder<DryingRecipe>> createRecipeOptional(DryingRackBlockEntity blockEntity, ServerLevel world) {
        return world.getServer().getRecipeManager().getRecipeFor((RecipeType)DryingRecipeType.INSTANCE, (RecipeInput)blockEntity.inventory.input, (Level)world);
    }
}

