/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.cardboardbox;

import java.util.Optional;
import me.luligabi.coxinhautilities.common.block.BlockRegistry;
import me.luligabi.coxinhautilities.common.block.cardboardbox.CardboardBoxBlockEntity;
import me.luligabi.coxinhautilities.common.misc.TagRegistry;
import me.luligabi.coxinhautilities.common.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class CardboardBoxBlockItem
extends BlockItem {
    public CardboardBoxBlockItem() {
        super(BlockRegistry.CARDBOARD_BOX.get(), new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState blockState;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Optional<BlockEntity> blockEntity = Optional.ofNullable(world.getBlockEntity(pos));
        if (context.getPlayer().isShiftKeyDown() && (blockState = world.getBlockState(pos)).getBlock().defaultDestroyTime() >= 0.01f && this.isNbtBlockAir(context.getItemInHand()) && !blockState.is(TagRegistry.UNBOXABLE) && !blockState.is(Tags.Blocks.RELOCATION_NOT_SUPPORTED)) {
            BlockEntity blockEntity2;
            if (blockEntity.isPresent() && this.hasLootTable(blockEntity.get())) {
                return super.useOn(context);
            }
            if (context.getLevel().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            ListTag nbtList = new ListTag();
            if (blockEntity.isPresent()) {
                CompoundTag nbtCopy = blockEntity.get().saveWithId((HolderLookup.Provider)world.registryAccess());
                nbtCopy.remove("id");
                nbtCopy.remove("x");
                nbtCopy.remove("y");
                nbtCopy.remove("z");
                nbtList.add((Object)nbtCopy);
                Clearable.tryClear(blockEntity);
                world.removeBlockEntity(pos);
            }
            world.setBlock(pos, BlockRegistry.CARDBOARD_BOX.get().getStateForPlacement(new BlockPlaceContext(context)), 32);
            world.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity = Optional.ofNullable(world.getBlockEntity(pos));
            if (blockEntity.isPresent() && (blockEntity2 = blockEntity.get()) instanceof CardboardBoxBlockEntity) {
                CardboardBoxBlockEntity cardboardBoxBE = (CardboardBoxBlockEntity)blockEntity2;
                cardboardBoxBE.blockState = blockState;
                cardboardBoxBE.nbtCopy = nbtList;
                blockEntity.get().setChanged();
            }
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    private boolean hasLootTable(BlockEntity blockEntity) {
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootableContainer = (RandomizableContainerBlockEntity)blockEntity;
            return lootableContainer.getLootTable() != null;
        }
        return false;
    }

    private boolean isNbtBlockAir(ItemStack stack) {
        if (stack.get(DataComponents.BLOCK_ENTITY_DATA) == null) {
            return true;
        }
        CompoundTag data = Util.getBlockEntityData(stack);
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)data.getCompound("BlockState")).isAir();
    }
}

