/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.aquatictorch;

import com.mojang.serialization.MapCodec;
import me.luligabi.coxinhautilities.common.block.aquatictorch.AquaticTorchBlock;
import me.luligabi.coxinhautilities.common.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WallAquaticTorchBlock
extends AquaticTorchBlock
implements SimpleWaterloggedBlock {
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public WallAquaticTorchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<WallAquaticTorchBlock> codec() {
        return WallAquaticTorchBlock.simpleCodec(WallAquaticTorchBlock::new);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction directionOpposite = direction.getOpposite();
        world.addParticle((ParticleOptions)Util.AQUATIC_TORCH_PARTICLE, x + 0.27 * (double)directionOpposite.getStepX(), y + 0.22, z + 0.27 * (double)directionOpposite.getStepZ(), 0.0, 0.0, 0.0);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        FluidState fluidState = world.getBlockState(pos).getFluidState();
        return super.canSurvive(state, world, pos) && fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction directionOpposite;
        Direction direction;
        Direction[] directionArray;
        BlockState blockstate = this.defaultBlockState();
        BlockPos blockpos = ctx.getClickedPos();
        Direction[] directionArray2 = directionArray = ctx.getNearestLookingDirections();
        int n = directionArray2.length;
        for (int i = 0; !(i >= n || (direction = directionArray2[i]).getAxis().isHorizontal() && (blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(directionOpposite = direction.getOpposite()))).canSurvive((LevelReader)ctx.getLevel(), blockpos)); ++i) {
        }
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }
}

