/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.client.screen.trashcan;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import joptsimple.internal.Strings;
import me.luligabi.coxinhautilities.mixin.HandledScreenAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class AbstractTrashCanScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    List<String> titleString;
    String titleline1;
    List<String> titleLine2;

    public AbstractTrashCanScreen(AbstractContainerMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, (Component)title.plainCopy().withStyle(ChatFormatting.WHITE));
        this.titleString = Arrays.asList((String[])this.title.getString().split(" ").clone());
        this.titleline1 = this.titleString.get(0);
        this.titleLine2 = this.titleString.subList(1, this.titleString.size());
        this.imageHeight = 167;
        ((HandledScreenAccessor)((Object)this)).setPlayerInventoryTitle((Component)this.playerInventoryTitle.plainCopy().withStyle(ChatFormatting.WHITE));
        this.inventoryLabelY = this.imageHeight - 93;
    }

    protected void renderBg(GuiGraphics ctx, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureIdentifier());
        ctx.blit(this.getTextureIdentifier(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.renderBackground(ctx, mouseX, mouseY, delta);
        super.render(ctx, mouseX, mouseY, delta);
        this.renderTooltip(ctx, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics ctx, int mouseX, int mouseY) {
        String titleLine2Spaced = Strings.join(this.titleLine2, (String)" ");
        ctx.drawString(this.font, this.titleline1, this.imageWidth / 2 - this.font.width(this.titleline1) / 2, 6, 0xFFFFFF, false);
        ctx.drawString(this.font, titleLine2Spaced, this.imageWidth / 2 - this.font.width(titleLine2Spaced) / 2, 17, 0xFFFFFF, false);
        ctx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 4, 0xFFFFFF, false);
    }

    protected abstract ResourceLocation getTextureIdentifier();
}

