/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.luligabi.coxinhautilities.common.block.BlockRegistry;
import me.luligabi.coxinhautilities.common.block.dryingrack.DryingRackBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class DryingRackBlockEntityRenderer
implements BlockEntityRenderer<DryingRackBlockEntity> {
    public DryingRackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DryingRackBlockEntity entity, float tickDelta, PoseStack ms, MultiBufferSource vcp, int light, int overlay) {
        if (entity.getStack().isEmpty()) {
            return;
        }
        ms.pushPose();
        if (entity.getLevel().getBlockState(entity.getBlockPos()).is(BlockRegistry.DRYING_RACK.get())) {
            Direction direction = (Direction)entity.getLevel().getBlockState(entity.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            ItemTransforms transformation = Minecraft.getInstance().getItemRenderer().getModel(entity.getStack(), null, null, 0).getTransforms();
            boolean isBlock = transformation.fixed.equals((Object)new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)));
            this.setItemPosition(ms, direction, isBlock);
            Axis axis = isBlock ? (direction.getAxis() == Direction.Axis.Z ? Axis.XP : Axis.YP) : (direction.getAxis() == Direction.Axis.Z ? Axis.XN : Axis.YN);
            ms.mulPose(axis.rotationDegrees(this.getItemAngle(direction)));
            if (direction == Direction.SOUTH && isBlock || direction == Direction.NORTH && !isBlock) {
                ms.mulPose(Axis.XP.rotationDegrees(180.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
            float scale = isBlock ? 0.75f : 0.99f;
            ms.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(entity.getStack(), isBlock ? ItemDisplayContext.NONE : ItemDisplayContext.GUI, light, OverlayTexture.NO_OVERLAY, ms, vcp, entity.getLevel(), (int)entity.getBlockPos().asLong());
        }
        ms.popPose();
    }

    public boolean shouldRenderOffScreen(DryingRackBlockEntity blockEntity) {
        return true;
    }

    private float getItemAngle(Direction direction) {
        return switch (direction) {
            case Direction.NORTH, Direction.SOUTH -> 0.0f;
            case Direction.WEST, Direction.EAST -> direction.get2DDataValue() * 90;
            default -> throw new IllegalStateException("Unexpected Drying Rack direction: " + String.valueOf(direction));
        };
    }

    private void setItemPosition(PoseStack ms, Direction direction, boolean isBlock) {
        double center = 0.5;
        double offset = direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? (isBlock ? 0.635 : 0.97) : (isBlock ? 0.365 : 0.03);
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                ms.translate(center, center, offset);
                break;
            }
            case WEST: 
            case EAST: {
                ms.translate(offset, center, center);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Drying Rack direction: " + String.valueOf(direction));
            }
        }
    }
}

