/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.client.compat.rei.drying;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.luligabi.coxinhautilities.client.compat.rei.CoxinhaReiPlugin;
import me.luligabi.coxinhautilities.common.recipe.drying.DryingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DryingRecipeDisplay
implements Display {
    protected RecipeHolder<DryingRecipe> recipe;
    protected List<EntryIngredient> input;
    protected List<EntryIngredient> output;
    protected int dryingTime;

    public DryingRecipeDisplay(RecipeHolder<DryingRecipe> recipe) {
        this.recipe = recipe;
        this.input = EntryIngredients.ofIngredients(List.of(((DryingRecipe)recipe.value()).getIngredient()));
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)((DryingRecipe)recipe.value()).getOutput()));
        this.dryingTime = ((DryingRecipe)recipe.value()).getDryingTime();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.recipe.id());
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CoxinhaReiPlugin.DRYING;
    }
}

