/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RenderUtil {
    public static final float TANK_W = 0.07f;
    public static final float TANK_START = 0.16f;
    public static final float TANK_FINAL = 0.84f;
    private static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, 1);

    public static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        boolean nX = true;
        boolean nY = true;
        boolean nZ = true;
        builder.addVertex(poseStack.last().pose(), x, y, z).setUv(u, v).setLight(packedLight).setColor(color).setNormal((float)nX, (float)nY, (float)nZ);
    }

    public static void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        RenderUtil.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        RenderUtil.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        RenderUtil.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        RenderUtil.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }

    public static void drawFluidInTank(FluidStack fluid, float fill, PoseStack ms, MultiBufferSource vcp, @Nullable Level world, @Nullable BlockPos pos, int light) {
        float bottomHeight;
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluid);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluid.getFluid().defaultFluidState();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = world == null && pos == null ? fluidTypeExtensions.getTintColor(fluid) : fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)world, pos);
        VertexConsumer builder = vcp.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
        boolean lighterThanAir = fluid.getFluidType().isLighterThanAir();
        float topHeight = !lighterThanAir ? fill : 0.93f;
        float f = bottomHeight = !lighterThanAir ? 0.07f : 1.0f - fill;
        if (fill < 1.0f) {
            ms.pushPose();
            if (lighterThanAir) {
                ms.mulPose(Axis.XP.rotationDegrees(180.0f));
                ms.translate(0.0, -1.93 + (double)fill, -1.0);
            }
            RenderUtil.drawQuad(builder, ms, 0.16f, topHeight, 0.16f, 0.84f, topHeight, 0.84f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
            ms.popPose();
        }
        RenderUtil.drawQuad(builder, ms, 0.16f, bottomHeight, 0.16f, 0.84f, topHeight, 0.16f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
        ms.pushPose();
        ms.mulPose(Axis.YP.rotationDegrees(180.0f));
        ms.translate(-1.0f, 0.0f, -1.68f);
        RenderUtil.drawQuad(builder, ms, 0.16f, bottomHeight, 0.84f, 0.84f, topHeight, 0.84f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(Axis.YP.rotationDegrees(90.0f));
        ms.translate(-1.0f, 0.0f, 0.0f);
        RenderUtil.drawQuad(builder, ms, 0.16f, bottomHeight, 0.16f, 0.84f, topHeight, 0.16f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
        ms.popPose();
        ms.pushPose();
        ms.mulPose(Axis.YN.rotationDegrees(90.0f));
        ms.translate(0.0f, 0.0f, -1.0f);
        RenderUtil.drawQuad(builder, ms, 0.16f, bottomHeight, 0.16f, 0.84f, topHeight, 0.16f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
        ms.popPose();
    }

    public static void drawWaterInSink(PoseStack ms, MultiBufferSource vcp, @Nullable Level world, @Nullable BlockPos pos, int light) {
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)WATER.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(WATER);
        if (stillTexture == null) {
            return;
        }
        FluidState state = WATER.getFluid().defaultFluidState();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = world == null && pos == null ? fluidTypeExtensions.getTintColor(WATER) : fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)world, pos);
        VertexConsumer builder = vcp.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
        RenderUtil.drawQuad(builder, ms, 0.16f, 0.82f, 0.16f, 0.84f, 0.82f, 0.84f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, tintColor);
    }

    public static void drawBakedModelAsItem(ItemStack stack, BakedModel model, PoseStack ms, MultiBufferSource vcp, int light, int overlay) {
        ms.pushPose();
        ms.translate(0.5, 0.5, 0.5);
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.NONE, false, ms, vcp, light, overlay, model);
        ms.popPose();
    }
}

