/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.slf4j.Logger;

public class PatchAuditTrailImpl
implements PatchAuditTrail {
    private static final DecimalFormat FORMAT = new DecimalFormat("##.00");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog> auditTrail = new LinkedHashMap<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog>();
    private final Map<PatchAuditTrail.Candidate, PatchAuditTrail.Match> candidates = new ConcurrentHashMap<PatchAuditTrail.Candidate, PatchAuditTrail.Match>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareMethod(MethodContext methodContext) {
        PatchAuditTrail.Candidate candidate = new PatchAuditTrail.Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        Map<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog> map = this.auditTrail;
        synchronized (map) {
            this.auditTrail.put(candidate, PatchAuditTrail.AuditLog.create(methodContext));
        }
    }

    @Override
    public void recordAudit(Object transform, ClassNode classNode, String message, Object ... args) {
        PatchAuditTrail.Candidate candidate = new PatchAuditTrail.Candidate(classNode, null);
        this.recordAudit(transform, null, candidate, message.formatted(args));
    }

    @Override
    public void recordAudit(Object transform, MethodContext methodContext, String message, Object ... args) {
        PatchAuditTrail.Candidate candidate = new PatchAuditTrail.Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        this.recordAudit(transform, methodContext.getMixinMethod(), candidate, message.formatted(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAudit(Object transform, @Nullable MethodNode methodNode, PatchAuditTrail.Candidate candidate, String message) {
        Map<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog> map = this.auditTrail;
        synchronized (map) {
            StringBuilder builder;
            PatchAuditTrail.AuditLog auditLog = this.auditTrail.computeIfAbsent(candidate, k -> new PatchAuditTrail.AuditLog(methodNode != null ? methodNode.name + methodNode.desc : null, new ArrayList<Pair<Object, StringBuilder>>()));
            List<Pair<Object, StringBuilder>> entries = auditLog.entries();
            if (entries.isEmpty() || entries.getLast().left() != transform) {
                builder = new StringBuilder();
                entries.add((Pair<Object, StringBuilder>)Pair.of((Object)transform, (Object)builder));
                builder.append("\n  >> Using ").append(transform.getClass().getName());
            } else {
                builder = (StringBuilder)entries.getLast().right();
            }
            builder.append("\n     - ").append(message);
            LOGGER.info(PatchInstance.MIXINPATCH, "Applying [{}] {}", (Object)transform.getClass().getSimpleName(), (Object)message);
        }
    }

    @Override
    public void recordResult(MethodContext methodContext, PatchAuditTrail.Match match) {
        PatchAuditTrail.Candidate candidate = new PatchAuditTrail.Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        this.candidates.compute(candidate, (key, prev) -> {
            PatchAuditTrail.Match maybeIgnore = match == PatchAuditTrail.Match.NONE && methodContext.isNotRequired() ? PatchAuditTrail.Match.IGNORED : match;
            return prev == null ? maybeIgnore : prev.or(maybeIgnore);
        });
    }

    @Override
    public String getCompleteReport() {
        StringBuilder builder = new StringBuilder();
        this.getSummaryLines().forEach(l -> builder.append((String)l).append("\n"));
        List<Map.Entry> failed = this.candidates.entrySet().stream().filter(m -> m.getValue() == PatchAuditTrail.Match.NONE || m.getValue() == PatchAuditTrail.Match.IGNORED).toList();
        if (!failed.isEmpty()) {
            builder.append("\n=============== Failed mixins ===============");
            failed.forEach(e -> builder.append("\n").append(e.getValue() == PatchAuditTrail.Match.IGNORED ? "(ignored) " : "").append(((PatchAuditTrail.Candidate)e.getKey()).classNode().name).append(" ").append(((PatchAuditTrail.Candidate)e.getKey()).methodNode().name).append(((PatchAuditTrail.Candidate)e.getKey()).methodNode().desc));
            builder.append("\n=============================================\n\n");
        } else {
            builder.append("\n");
        }
        this.auditTrail.forEach((candidate, auditLog) -> {
            if (auditLog.entries().isEmpty()) {
                return;
            }
            if (auditLog.originalMethod() == null) {
                builder.append("Mixin class ").append(candidate.classNode().name);
            } else {
                builder.append("Mixin method ").append(candidate.classNode().name).append(" ").append(auditLog.originalMethod());
            }
            for (Pair<Object, StringBuilder> record : auditLog.entries()) {
                builder.append((CharSequence)record.right());
            }
            builder.append("\n\n");
        });
        return builder.toString();
    }

    @Override
    public List<PatchAuditTrail.Candidate> getFailingMixins() {
        return this.candidates.entrySet().stream().filter(m -> m.getValue() == PatchAuditTrail.Match.NONE).map(Map.Entry::getKey).toList();
    }

    @Override
    public Map<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog> getAuditTrail() {
        return this.auditTrail;
    }

    @Override
    public Map<PatchAuditTrail.Candidate, PatchAuditTrail.Match> getCandidates() {
        return this.candidates;
    }

    @Override
    @Nullable
    public PatchAuditTrail.Match getMatch(MethodContext methodContext) {
        PatchAuditTrail.Candidate candidate = new PatchAuditTrail.Candidate(methodContext.getMixinClass(), methodContext.getMixinMethod());
        return this.candidates.get(candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(PatchAuditTrail other) {
        Map<PatchAuditTrail.Candidate, PatchAuditTrail.AuditLog> map = this.auditTrail;
        synchronized (map) {
            this.auditTrail.putAll(other.getAuditTrail());
        }
        this.candidates.putAll(other.getCandidates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void silenceClasses(Set<String> classes) {
        Map<PatchAuditTrail.Candidate, PatchAuditTrail.Match> map = this.candidates;
        synchronized (map) {
            for (PatchAuditTrail.Candidate candidate : Set.copyOf(this.candidates.keySet())) {
                if (!classes.contains(candidate.classNode().name)) continue;
                this.candidates.put(candidate, PatchAuditTrail.Match.IGNORED);
            }
        }
    }

    private List<String> getSummaryLines() {
        int total = this.candidates.size();
        int successful = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.FULL).count();
        int partial = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.PARTIAL).count();
        int failed = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.NONE).count();
        int silenced = (int)this.candidates.values().stream().filter(m -> m == PatchAuditTrail.Match.IGNORED).count();
        double rate = (double)(successful + partial) / (double)total * 100.0;
        double accuracy = ((double)successful / (double)total + (double)partial / (double)total / 2.0) * 100.0;
        return List.of("==== Connector Mixin Patch Audit Summary ====", "Successful: %s".formatted(successful), "Partial: %s".formatted(partial), "Failed: %s%s".formatted(failed, silenced > 0 ? " (%s ignored)".formatted(silenced) : ""), "Success rate: %s%%        Accuracy: %s%%".formatted(FORMAT.format(rate), FORMAT.format(accuracy)), "=============================================");
    }

    @Override
    public boolean hasFailingMixins() {
        return !this.getFailingMixins().isEmpty();
    }
}

