/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.shaderpack;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.engine_room.flywheel.api.material.Transparency;
import java.util.Optional;

public enum ClrwlProgramGroup {
    GBUFFERS("gbuffers"),
    SHADOW("shadow");

    private final String name;

    private ClrwlProgramGroup(String name) {
        this.name = name;
    }

    public String groupName() {
        return this.name;
    }

    public Optional<ClrwlProgramId> getProgramFromTransparency(Transparency transparency) {
        switch (this.ordinal()) {
            case 0: {
                return ClrwlProgramGroup.gbuffersFromTransparency(transparency);
            }
            case 1: {
                return ClrwlProgramGroup.shadowFromTransparency(transparency);
            }
        }
        Colorwheel.LOGGER.error("Unknown program group: {}", (Object)this);
        return Optional.empty();
    }

    private static Optional<ClrwlProgramId> gbuffersFromTransparency(Transparency transparency) {
        switch (transparency) {
            case OPAQUE: {
                return Optional.of(ClrwlProgramId.GBUFFERS);
            }
            case ADDITIVE: {
                return Optional.of(ClrwlProgramId.GBUFFERS_ADDITIVE);
            }
            case LIGHTNING: {
                return Optional.of(ClrwlProgramId.GBUFFERS_LIGHTNING);
            }
            case GLINT: {
                return Optional.of(ClrwlProgramId.GBUFFERS_GLINT);
            }
            case CRUMBLING: {
                return Optional.of(ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK);
            }
            case TRANSLUCENT: 
            case ORDER_INDEPENDENT: {
                return Optional.of(ClrwlProgramId.GBUFFERS_TRANSLUCENT);
            }
        }
        Colorwheel.LOGGER.error("Unknown transparency: {}", (Object)transparency);
        return Optional.empty();
    }

    private static Optional<ClrwlProgramId> shadowFromTransparency(Transparency transparency) {
        switch (transparency) {
            case OPAQUE: {
                return Optional.of(ClrwlProgramId.SHADOW);
            }
            case ADDITIVE: {
                return Optional.of(ClrwlProgramId.SHADOW_ADDITIVE);
            }
            case LIGHTNING: {
                return Optional.of(ClrwlProgramId.SHADOW_LIGHTNING);
            }
            case GLINT: {
                return Optional.of(ClrwlProgramId.SHADOW_GLINT);
            }
            case CRUMBLING: {
                return Optional.empty();
            }
            case TRANSLUCENT: 
            case ORDER_INDEPENDENT: {
                return Optional.of(ClrwlProgramId.SHADOW_TRANSLUCENT);
            }
        }
        Colorwheel.LOGGER.error("Unknown transparency: {}", (Object)transparency);
        return Optional.empty();
    }
}

