/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.engine.uniform.LevelUniforms;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;

public final class ClrwlLevelUniforms
extends UniformWriter {
    private static final int SIZE = 60;
    static final UniformBuffer BUFFER = new UniformBuffer(1, 60);

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        ClientLevel level = context.level();
        float partialTick = context.partialTick();
        Vec3 cloudColor = level.getCloudColor(partialTick);
        ptr = ClrwlLevelUniforms.writeVec4(ptr, (float)cloudColor.x, (float)cloudColor.y, (float)cloudColor.z, 1.0f);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LevelUniforms.LIGHT0_DIRECTION);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LevelUniforms.LIGHT1_DIRECTION);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getMoonBrightness());
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.getSkyDarken(partialTick));
        ResourceKey dimension = level.dimension();
        int dimensionId = Level.OVERWORLD.equals(dimension) ? 0 : (Level.NETHER.equals(dimension) ? 1 : (Level.END.equals(dimension) ? 2 : -1));
        ptr = ClrwlLevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

