/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MissingItem;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final BlockPos pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;
    private final List<Tuple<ProviderPipe, RequestedItem>> queue;
    private final Map<ProviderPipe, List<ItemStack>> takenFromCache;
    private final List<ItemStack> spareItems;
    private final Set<Item> craftedItemsForAdvancement;

    public PipeNetwork(BlockPos pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
        this.queue = new ArrayList<Tuple<ProviderPipe, RequestedItem>>();
        this.takenFromCache = new HashMap<ProviderPipe, List<ItemStack>>();
        this.spareItems = new ArrayList<ItemStack>();
        this.craftedItemsForAdvancement = new HashSet<Item>();
    }

    public PipeNetwork(BlockPos pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private void enqueue(ItemStack stack, int amount, BlockPos requestPos, String playerName, ProviderPipe providerPipe) {
        RequestedItem requestedItem = new RequestedItem(stack.copyWithCount(amount), requestPos, playerName);
        boolean matched = false;
        for (Tuple<ProviderPipe, RequestedItem> tuple : this.queue) {
            if (tuple.a() != providerPipe || !requestedItem.matches(tuple.b())) continue;
            matched = true;
            tuple.b().getStack().grow(amount);
            break;
        }
        if (!matched) {
            this.queue.add(new Tuple<ProviderPipe, RequestedItem>(providerPipe, requestedItem));
        }
    }

    private MissingItem queueRequest(ItemStack stack, BlockPos requestPos, Player player, List<ItemStack> visited) {
        MissingItem missingItem = new MissingItem(stack.copy());
        String playerName = player != null ? player.getName().getString() : "";
        ListIterator<ItemStack> iterator = this.spareItems.listIterator();
        while (iterator.hasNext()) {
            ItemStack spareItem = (ItemStack)iterator.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)spareItem, (ItemStack)stack)) continue;
            int amount = Math.min(spareItem.getCount(), missingItem.getCount());
            spareItem.shrink(amount);
            missingItem.shrink(amount);
            if (spareItem.isEmpty()) {
                iterator.remove();
            }
            this.enqueue(stack, amount, requestPos, playerName, null);
            break;
        }
        if (!missingItem.isEmpty()) {
            block1: for (ProviderPipe providerPipe : this.providerPipes) {
                if (missingItem.isEmpty()) break;
                ArrayList<ItemStack> alreadyTaken = this.takenFromCache.containsKey(providerPipe) ? this.takenFromCache.get(providerPipe) : new ArrayList<ItemStack>();
                for (ItemStack cacheStack : providerPipe.getCache()) {
                    int amount;
                    ItemStack takenStack;
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)cacheStack)) continue;
                    int cacheCount = cacheStack.getCount();
                    int takenIndex = -1;
                    for (int i = 0; i < alreadyTaken.size(); ++i) {
                        takenStack = (ItemStack)alreadyTaken.get(i);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)cacheStack, (ItemStack)takenStack)) continue;
                        cacheCount -= takenStack.getCount();
                        takenIndex = i;
                        break;
                    }
                    if ((amount = Math.min(missingItem.getCount(), cacheCount)) <= 0) continue block1;
                    this.enqueue(stack, amount, requestPos, playerName, providerPipe);
                    missingItem.shrink(amount);
                    if (takenIndex >= 0) {
                        takenStack = (ItemStack)alreadyTaken.get(takenIndex);
                        alreadyTaken.set(takenIndex, takenStack.copyWithCount(takenStack.getCount() + amount));
                    } else {
                        alreadyTaken.add(cacheStack.copyWithCount(amount));
                    }
                    this.takenFromCache.put(providerPipe, alreadyTaken);
                    continue block1;
                }
            }
        }
        if (!missingItem.isEmpty()) {
            boolean foundCraftingPipe = false;
            for (RecipePipeEntity craftingPipe : this.recipePipes) {
                ItemStack result = craftingPipe.getResult();
                if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)stack)) continue;
                if (foundCraftingPipe) {
                    if (player == null) break;
                    player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.multiple_recipes", (Object[])new Object[]{stack.getItem().getDescription()}).withStyle(ChatFormatting.YELLOW), false);
                    break;
                }
                int requiredCrafts = Math.ceilDiv(missingItem.getCount(), result.getCount());
                List<ItemStack> ingredients = craftingPipe.getIngredientsCollated();
                boolean canCraft = true;
                for (ItemStack ingredient : ingredients) {
                    boolean alreadyVisited = false;
                    for (ItemStack visitedStack : visited) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)visitedStack, (ItemStack)ingredient)) continue;
                        alreadyVisited = true;
                        canCraft = false;
                        break;
                    }
                    if (alreadyVisited) continue;
                    ArrayList<ItemStack> visited2 = new ArrayList<ItemStack>(visited);
                    visited2.add(stack);
                    MissingItem missingForCraft = this.queueRequest(ingredient.copyWithCount(ingredient.getCount() * requiredCrafts), craftingPipe.getBlockPos(), player, visited2);
                    if (missingForCraft.isEmpty()) continue;
                    missingItem.addMissingIngredient(missingForCraft);
                    canCraft = false;
                }
                if (canCraft) {
                    int amount = Math.min(result.getCount() * requiredCrafts, missingItem.getCount());
                    missingItem.shrink(amount);
                    this.enqueue(stack, amount, requestPos, playerName, null);
                    if (result.getCount() * requiredCrafts > amount) {
                        int remaining = result.getCount() * requiredCrafts - amount;
                        boolean matched = false;
                        for (ItemStack spareItem : this.spareItems) {
                            if (!ItemStack.isSameItemSameComponents((ItemStack)spareItem, (ItemStack)stack)) continue;
                            spareItem.grow(remaining);
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            this.spareItems.add(stack.copyWithCount(remaining));
                        }
                    }
                    this.craftedItemsForAdvancement.add(result.getItem());
                }
                foundCraftingPipe = true;
            }
        }
        return missingItem;
    }

    public void request(ServerLevel level, ItemStack stack, BlockPos requestPos, Player player, boolean partialRequest) {
        block6: {
            MissingItem missingItem;
            block4: {
                block5: {
                    missingItem = this.queueRequest(stack.copy(), requestPos, player, new ArrayList<ItemStack>());
                    if (!missingItem.isEmpty()) break block4;
                    boolean cancelled = false;
                    for (Tuple<ProviderPipe, RequestedItem> tuple2 : this.queue) {
                        this.addRequestedItem(tuple2.b());
                        if (tuple2.a() == null || tuple2.a().extractItem(level, tuple2.b().getStack())) continue;
                        cancelled = true;
                        if (partialRequest) break;
                        tuple2.b().sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription(), tuple2.a().getProviderPipePos().toShortString()}).withStyle(ChatFormatting.RED));
                        break;
                    }
                    if (!cancelled) break block5;
                    this.queue.forEach(tuple -> this.removeRequestedItem((RequestedItem)tuple.b()));
                    break block6;
                }
                if (player == null) break block6;
                player.awardStat(ClassicPipes.ITEMS_REQUESTED_STAT, stack.getCount());
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((ServerPlayer)player, stack, this.craftedItemsForAdvancement.size());
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription()}).withStyle(ChatFormatting.GREEN), false);
                break block6;
            }
            if (partialRequest && missingItem.getCount() < stack.getCount()) {
                this.resetForNewRequest();
                this.request(level, stack.copyWithCount(stack.getCount() - missingItem.getCount()), requestPos, player, false);
                return;
            }
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription()}).withStyle(ChatFormatting.RED), false);
                for (ItemStack missing : missingItem.getBaseItems(new ArrayList<ItemStack>())) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missing.getCount(), missing.getItem().getDescription()}).withStyle(ChatFormatting.YELLOW), false);
                }
            }
        }
        this.resetForNewRequest();
    }

    private void resetForNewRequest() {
        this.queue.clear();
        this.takenFromCache.clear();
        this.spareItems.clear();
        this.craftedItemsForAdvancement.clear();
    }

    public void tick(ServerLevel level) {
        int updatablePipesCount = this.providerPipes.size() + this.matchingPipes.size() + this.stockingPipes.size();
        int pipeToUpdate = level.getRandom().nextInt(Math.max(100, updatablePipesCount));
        if (pipeToUpdate < this.providerPipes.size()) {
            i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    Direction facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < this.providerPipes.size() + this.matchingPipes.size()) {
            i = 0;
            for (MatchingPipe matchingPipe : this.matchingPipes) {
                if (i == pipeToUpdate) {
                    matchingPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < updatablePipesCount) {
            i = 0;
            for (Object stockingPipe : this.stockingPipes) {
                if (i == pipeToUpdate) {
                    stockingPipe.updateCache();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.getPlayers(player -> {
                RequestMenu menu;
                AbstractContainerMenu patt0$temp = player.containerMenu;
                return patt0$temp instanceof RequestMenu && (menu = (RequestMenu)patt0$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (ServerPlayer player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (Object stockingPipe : this.stockingPipes) {
                if (!stockingPipe.isActiveStocking()) continue;
                stockingPipe.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().getItem().getDescription()}).withStyle(ChatFormatting.RED));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.getBlockPos());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(ServerLevel level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.getBlockPos());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(ServerLevel level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.getBlockPos())) {
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().getItem().getDescription(), pipe.getBlockPos().toShortString()}).withStyle(ChatFormatting.RED));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(BlockPos requestPos) {
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (ItemStack stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (ItemStack inStack : existingItems) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)inStack)) continue;
                    inStack.grow(stack.getCount());
                    if (inStack.getCount() < 0) {
                        inStack.setCount(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.copy());
            }
        }
        ArrayList<ItemStack> craftableItems = new ArrayList<ItemStack>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            ItemStack result = recipePipe.getResult();
            if (result.isEmpty()) continue;
            boolean matched = false;
            for (ItemStack alreadyCraftable : craftableItems) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)alreadyCraftable, (ItemStack)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.copyWithCount(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.sortingMode, this.pos, requestPos);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

