/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.container;

import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.item.LabelItem;
import jagm.classicpipes.item.TagLabelItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DirectionalFilterContainer
implements Filter {
    private final Map<Direction, NonNullList<ItemStack>> filterMap;
    private final PipeEntity pipe;
    private boolean matchComponents;

    public DirectionalFilterContainer(PipeEntity pipe, boolean matchComponents) {
        this.pipe = pipe;
        this.filterMap = new HashMap<Direction, NonNullList<ItemStack>>();
        this.matchComponents = matchComponents;
        this.clearContent();
    }

    public Filter.MatchingResult directionMatches(ItemStack stack, Direction direction) {
        for (ItemStack filterStack : this.filterMap.get(direction)) {
            LabelItem labelItem;
            Item item = filterStack.getItem();
            if (item instanceof LabelItem && (labelItem = (LabelItem)item).itemMatches(filterStack, stack)) {
                return labelItem instanceof TagLabelItem ? Filter.MatchingResult.TAG : Filter.MatchingResult.MOD;
            }
            if (!filterStack.is(stack.getItem()) || this.shouldMatchComponents() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) continue;
            return Filter.MatchingResult.ITEM;
        }
        return Filter.MatchingResult.FALSE;
    }

    public boolean directionEmpty(Direction direction) {
        return this.filterMap.get(direction).stream().allMatch(ItemStack::isEmpty);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getContainerSize() {
        return 54;
    }

    public boolean isEmpty() {
        for (Direction direction : Direction.values()) {
            if (this.directionEmpty(direction)) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        return (ItemStack)this.filterMap.get(Direction.from3DDataValue((int)row)).get(col);
    }

    public ItemStack removeItem(int slot, int amount) {
        int row = slot / 9;
        int col = slot % 9;
        this.filterMap.get(Direction.from3DDataValue((int)row)).set(col, (Object)ItemStack.EMPTY);
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeItem(slot, 1);
    }

    public void setItem(int slot, ItemStack stack) {
        int row = slot / 9;
        int col = slot % 9;
        this.filterMap.get(Direction.from3DDataValue((int)row)).set(col, (Object)stack);
    }

    public void setChanged() {
        if (this.pipe != null && this.pipe.getLevel() != null) {
            this.pipe.getLevel().sendBlockUpdated(this.pipe.getBlockPos(), this.pipe.getBlockState(), this.pipe.getBlockState(), 2);
            this.pipe.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        if (this.pipe != null) {
            return Container.stillValidBlockEntity((BlockEntity)this.pipe, (Player)player);
        }
        return true;
    }

    public void clearContent() {
        for (Direction direction : Direction.values()) {
            this.filterMap.put(direction, (NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));
        }
    }

    @Override
    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
        this.setChanged();
    }

    @Override
    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    @Override
    public PipeEntity getPipe() {
        return this.pipe;
    }
}

