/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.RequestScreen;
import jagm.classicpipes.client.screen.widget.IncreaseButton;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ServerBoundRequestPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RequestAmountScreen
extends Screen {
    private static final int IMAGE_WIDTH = 176;
    private static final int IMAGE_HEIGHT = 96;
    private static final int ITEM_X = 62;
    private static final int ITEM_Y = 36;
    private static final int MAX_REQUEST = 999;
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/request_amount.png");
    private final RequestScreen previousScreen;
    private final ItemStack stack;
    private final boolean craftable;
    private int leftPos;
    private int topPos;
    private int count;
    private IncreaseButton increase;
    private IncreaseButton decrease;

    protected RequestAmountScreen(ItemStack stack, RequestScreen previousScreen, boolean craftable) {
        super((Component)Component.translatable((String)"container.classicpipes.request.amount"));
        this.stack = stack;
        this.previousScreen = previousScreen;
        this.craftable = craftable;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 96) / 2;
        this.count = 1;
        this.increase = new IncreaseButton(this.leftPos + 62 + 38, this.topPos + 26, false, this.stack.getCount() > 1 || this.craftable, button -> this.changeCount(RequestAmountScreen.hasShiftDown() ? 10 : 1));
        this.decrease = new IncreaseButton(this.leftPos + 62 + 38, this.topPos + 54, true, false, button -> this.changeCount(RequestAmountScreen.hasShiftDown() ? -10 : -1));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"widget.classicpipes.cancel"), button -> this.onClose()).bounds(this.leftPos + 16, this.topPos + 72, 70, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"widget.classicpipes.request"), button -> {
            Services.LOADER_SERVICE.sendToServer(new ServerBoundRequestPayload(this.stack.copyWithCount(this.count), ((RequestMenu)this.previousScreen.getMenu()).getRequestPos()));
            this.previousScreen.onClose();
        }).bounds(this.leftPos + 90, this.topPos + 72, 70, 16).build());
        this.addRenderableWidget((GuiEventListener)this.increase);
        this.addRenderableWidget((GuiEventListener)this.decrease);
    }

    private void changeCount(int increment) {
        this.count += increment;
        if (this.count < 1) {
            this.count = 1;
        }
        if (this.count > this.stack.getCount() && !this.craftable) {
            this.count = this.stack.getCount();
        }
        if (this.count > 999) {
            this.count = 999;
        }
        this.decrease.active = this.count > 1;
        this.increase.active = this.count < this.stack.getCount() || this.craftable && this.count < 999;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        graphics.renderItem(this.stack, 62, 36);
        if (this.stack.isBarVisible()) {
            int i = 64;
            int j = 49;
            graphics.fill(RenderType.gui(), i, j, i + 13, j + 2, -16777216);
            graphics.fill(RenderType.gui(), i, j, i + this.stack.getBarWidth(), j + 1, this.stack.getBarColor() | 0xFF000000);
        }
        graphics.drawString(this.font, this.title, (176 - this.font.width((FormattedText)this.title)) / 2, 6, -12566464, false);
        MutableComponent countComponent = Component.literal((String)String.valueOf(this.count));
        graphics.drawString(this.font, (Component)countComponent, 107 - this.font.width((FormattedText)countComponent) / 2, 40, -12566464, false);
        if (this.isHovering(62, 36, 16, 16, mouseX, mouseY) && this.minecraft != null) {
            graphics.renderTooltip(this.font, RequestAmountScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.stack), this.stack.getTooltipImage(), mouseX, mouseY);
        }
        graphics.pose().popPose();
    }

    private boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(graphics);
        int i = (this.width - 176) / 2;
        int j = (this.height - 96) / 2;
        graphics.blit(BACKGROUND, i, j, 0.0f, 0.0f, 176, 96, 256, 256);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.previousScreen);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.minecraft != null && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.changeCount((int)(RequestAmountScreen.hasShiftDown() ? 10.0 * scrollY : scrollY));
        return true;
    }
}

