/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import com.mojang.serialization.DynamicOps;
import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class ItemPipeEntity
extends PipeEntity {
    protected final List<ItemInPipe> contents = new ArrayList<ItemInPipe>();
    protected final List<ItemInPipe> queued = new ArrayList<ItemInPipe>();
    public final Map<Direction, Tuple<BlockPos, Integer>> networkDistances = new HashMap<Direction, Tuple<BlockPos, Integer>>();
    private boolean networkingInitialised = false;
    private final Map<ItemInPipe, Long> tickAdded = new HashMap<ItemInPipe, Long>();

    public ItemPipeEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        boolean sendBlockUpdate = false;
        if (!this.networkingInitialised) {
            this.initialiseNetworking(level, state, pos);
            this.networkingInitialised = true;
            sendBlockUpdate = true;
        }
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.getGameTime()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() >= 1024 && item.isEjecting()) {
                    iterator.remove();
                    this.eject(level, pos, item);
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() < 2048) continue;
                if (Services.LOADER_SERVICE.handleItemInsertion(this, level, pos, state, item)) {
                    iterator.remove();
                } else {
                    ItemPipeEntity itemPipeEntity = this;
                    if (itemPipeEntity instanceof MatchingPipe) {
                        MatchingPipe matchingPipe = (MatchingPipe)((Object)itemPipeEntity);
                        matchingPipe.markCannotFit(item.getStack());
                    }
                }
                sendBlockUpdate = true;
            }
            this.addQueuedItems((Level)level, false);
        }
        if (sendBlockUpdate) {
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(Level level, BlockPos pos) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                BlockPos nextPos;
                BlockEntity blockEntity;
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.getGameTime()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getProgress() < 2048 || !((blockEntity = level.getBlockEntity(nextPos = pos.relative(item.getTargetDirection()))) instanceof ItemPipeEntity)) continue;
                ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
                item.resetProgress(item.getTargetDirection().getOpposite());
                nextPipe.insertPipeItem(level, item);
                iterator.remove();
            }
        }
    }

    public void insertPipeItem(Level level, ItemInPipe item) {
        this.queued.add(item);
        this.routeItem(item);
        this.addQueuedItems(level, true);
    }

    public void addQueuedItems(Level level, boolean waitForNextTick) {
        for (ItemInPipe item : this.queued) {
            this.contents.add(item);
            if (!waitForNextTick) continue;
            this.tickAdded.put(item, level.getGameTime());
        }
        this.setChanged();
        this.queued.clear();
    }

    public abstract void routeItem(BlockState var1, ItemInPipe var2);

    public final void routeItem(ItemInPipe item) {
        this.routeItem(this.getBlockState(), item);
    }

    protected boolean canJoinNetwork() {
        return true;
    }

    @Override
    protected void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (!wasConnected || item.getTargetDirection() == direction && item.getFromDirection() != direction && item.getProgress() < 1024) {
                    this.routeItem(state, item);
                    continue;
                }
                if ((item.getFromDirection() != direction || item.getProgress() >= 1024) && (item.getTargetDirection() != direction || item.getProgress() < 1024)) continue;
                iterator.remove();
                item.drop(level, pos);
            }
            this.addQueuedItems((Level)level, false);
        }
        if (wasConnected) {
            this.networkDistances.remove(direction);
        }
        boolean flaggedChange = false;
        for (Direction otherDirection : Direction.values()) {
            if (this.isPipeConnected(state, otherDirection)) continue;
            this.networkDistances.remove(otherDirection);
            ItemPipeEntity itemPipeEntity = this;
            if (!(itemPipeEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity networkedPipe = (NetworkedPipeEntity)itemPipeEntity;
            if (flaggedChange) continue;
            networkedPipe.networkChanged(level, pos, false);
            flaggedChange = true;
        }
        for (Direction otherDirection : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos nextPos = pos.relative(otherDirection);
            if (!this.isPipeConnected(state, otherDirection) || !((blockEntity = level.getBlockEntity(nextPos)) instanceof ItemPipeEntity)) continue;
            ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
            this.updateNetworking(level, state, pos, nextPipe, nextPos, otherDirection, new HashSet<Tuple<BlockPos, Direction>>(), true);
        }
        this.setChanged();
        level.sendBlockUpdated(pos, state, state, 2);
    }

    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        Set<Tuple<BlockPos, Direction>> visited = new HashSet<Tuple<BlockPos, Direction>>();
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos nextPos = pos.relative(direction);
            if (this.isPipeConnected(state, direction) && (blockEntity = level.getBlockEntity(nextPos)) instanceof ItemPipeEntity) {
                ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
                visited = this.updateNetworking(level, state, pos, nextPipe, nextPos, direction, visited, false);
                continue;
            }
            this.networkDistances.remove(direction);
        }
        this.setChanged();
    }

    private Set<Tuple<BlockPos, Direction>> updateNetworking(ServerLevel level, BlockState state, BlockPos pos, ItemPipeEntity nextPipe, BlockPos nextPos, Direction nextDirection, Set<Tuple<BlockPos, Direction>> visited, boolean triggerNetworkChanges) {
        Block wasLinked22;
        NetworkedPipeEntity networkedPipe;
        Tuple<BlockPos, Integer> tuple;
        for (Tuple<BlockPos, Direction> tuple2 : visited) {
            if (!tuple2.a().equals((Object)pos) || !tuple2.b().equals((Object)nextDirection)) continue;
            return visited;
        }
        visited.add(new Tuple<BlockPos, Direction>(pos, nextDirection));
        if (this instanceof NetworkedPipeEntity && nextPipe.canJoinNetwork()) {
            nextPipe.networkDistances.put(nextDirection.getOpposite(), new Tuple<BlockPos, Integer>(pos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (this.countConnections(state) < 3) {
                for (Direction direction : this.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection) || !nextPipe.canJoinNetwork()) continue;
                    tuple = this.networkDistances.get(direction);
                    nextPipe.networkDistances.put(nextDirection.getOpposite(), new Tuple<BlockPos, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                nextPipe.networkDistances.remove(nextDirection.getOpposite());
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && this.canJoinNetwork()) {
            this.networkDistances.put(nextDirection, new Tuple<BlockPos, Integer>(nextPos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (nextPipe.countConnections(nextPipe.getBlockState()) < 3) {
                for (Direction direction : nextPipe.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection.getOpposite()) || !this.canJoinNetwork()) continue;
                    tuple = nextPipe.networkDistances.get(direction);
                    this.networkDistances.put(nextDirection, new Tuple<BlockPos, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                this.networkDistances.remove(nextDirection);
            }
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity;
                if (direction.equals((Object)nextDirection.getOpposite())) continue;
                BlockPos anotherPos = nextPos.relative(direction);
                if (nextPipe.isPipeConnected(nextPipe.getBlockState(), direction) && (blockEntity = level.getBlockEntity(anotherPos)) instanceof ItemPipeEntity) {
                    ItemPipeEntity anotherPipe = (ItemPipeEntity)blockEntity;
                    visited = nextPipe.updateNetworking(level, nextPipe.getBlockState(), nextPos, anotherPipe, anotherPos, direction, visited, triggerNetworkChanges);
                    continue;
                }
                nextPipe.networkDistances.remove(direction);
            }
        }
        ItemPipeEntity direction = this;
        if (direction instanceof NetworkedPipeEntity) {
            networkedPipe = (NetworkedPipeEntity)direction;
            direction = state.getBlock();
            if (direction instanceof NetworkedPipeBlock) {
                boolean isLinked;
                NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)((Object)direction);
                boolean wasLinked22 = networkedPipeBlock.isLinked(state, nextDirection);
                if (wasLinked22 != (isLinked = this.networkDistances.containsKey(nextDirection)) && triggerNetworkChanges) {
                    networkedPipe.networkChanged(level, pos, isLinked);
                }
                level.setBlock(pos, networkedPipeBlock.setLinked(state, nextDirection, isLinked), 3);
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && (wasLinked22 = (networkedPipe = (NetworkedPipeEntity)nextPipe).getBlockState().getBlock()) instanceof NetworkedPipeBlock) {
            boolean isLinked;
            NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)wasLinked22;
            boolean wasLinked3 = networkedPipeBlock.isLinked(networkedPipe.getBlockState(), nextDirection.getOpposite());
            if (wasLinked3 != (isLinked = networkedPipe.networkDistances.containsKey(nextDirection.getOpposite())) && triggerNetworkChanges) {
                networkedPipe.networkChanged(level, nextPos, isLinked);
            }
            level.setBlock(nextPos, networkedPipeBlock.setLinked(networkedPipe.getBlockState(), nextDirection.getOpposite(), isLinked), 3);
        }
        this.setChanged();
        level.sendBlockUpdated(pos, state, state, 2);
        nextPipe.setChanged();
        level.sendBlockUpdated(nextPos, nextPipe.getBlockState(), nextPipe.getBlockState(), 2);
        return visited;
    }

    public void eject(ServerLevel level, BlockPos pos, ItemInPipe item) {
        if (!item.getStack().isEmpty()) {
            Vec3 offset = new Vec3(item.getTargetDirection() == Direction.WEST ? 0.125 : (double)(item.getTargetDirection() == Direction.EAST ? 0.875f : 0.5f), item.getTargetDirection() == Direction.DOWN ? 0.0 : (double)(item.getTargetDirection() == Direction.UP ? 0.75f : 0.375f), item.getTargetDirection() == Direction.NORTH ? 0.125 : (double)(item.getTargetDirection() == Direction.SOUTH ? 0.875f : 0.5f));
            ItemEntity ejectedItem = new ItemEntity((Level)level, (double)pos.getX() + offset.x, (double)pos.getY() + offset.y, (double)pos.getZ() + offset.z, item.getStack());
            float v = (float)item.getSpeed() / 2048.0f;
            ejectedItem.setDeltaMovement(item.getTargetDirection() == Direction.WEST ? (double)(-v) : (double)(item.getTargetDirection() == Direction.EAST ? v : 0.0f), item.getTargetDirection() == Direction.DOWN ? (double)(-v) : (double)(item.getTargetDirection() == Direction.UP ? v : 0.0f), item.getTargetDirection() == Direction.NORTH ? (double)(-v) : (double)(item.getTargetDirection() == Direction.SOUTH ? v : 0.0f));
            ejectedItem.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)ejectedItem);
            level.playSound(null, pos, ClassicPipes.PIPE_EJECT_SOUND, SoundSource.BLOCKS);
        }
    }

    public void dropItems(ServerLevel serverLevel, BlockPos pos) {
        for (ItemInPipe item : this.contents) {
            item.drop(serverLevel, pos);
        }
    }

    public List<ItemInPipe> getContents() {
        return this.contents;
    }

    public void setItem(Direction side, ItemStack stack) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!stack.isEmpty()) {
                ItemInPipe item = new ItemInPipe(stack, side, side.getOpposite());
                this.insertPipeItem((Level)serverLevel, item);
                serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.clearContent();
        this.networkDistances.clear();
        this.tickAdded.clear();
        super.loadAdditional(valueInput, registries);
        ListTag itemsList = valueInput.getList("items", 10);
        itemsList.forEach(tag -> MiscUtil.loadFromTag(tag, ItemInPipe.CODEC, registries, this.contents::add));
        for (Direction direction : Direction.values()) {
            MiscUtil.loadFromTag(valueInput.get(direction.getName() + "_pos"), BlockPos.CODEC, registries, pos -> {
                if (valueInput.contains(direction.getName() + "_distance")) {
                    this.networkDistances.put(direction, new Tuple<BlockPos, Integer>((BlockPos)pos, valueInput.getInt(direction.getName() + "_distance")));
                }
            });
        }
    }

    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        ListTag itemsList = new ListTag();
        for (ItemInPipe item : this.contents) {
            if (item.getStack().isEmpty()) continue;
            MiscUtil.saveToTag((Tag)new CompoundTag(), item, ItemInPipe.CODEC, registries, arg_0 -> itemsList.add(arg_0));
        }
        valueOutput.put("items", (Tag)itemsList);
        for (Direction direction : this.networkDistances.keySet()) {
            Tuple<BlockPos, Integer> tuple = this.networkDistances.get(direction);
            valueOutput.put(direction.getName() + "_pos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)tuple.a()).getOrThrow());
            valueOutput.putInt(direction.getName() + "_distance", tuple.b().intValue());
        }
    }

    public void clearContent() {
        this.contents.clear();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @Override
    public int getComparatorOutput() {
        return Math.min(15, this.getContents().size());
    }
}

