/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.blockEntity;

import dan200.computercraft.api.peripheral.IPeripheral;
import dev.kleinbox.cccbridge.client.animatronic.RustyMovement;
import dev.kleinbox.cccbridge.common.CCCRegistries;
import dev.kleinbox.cccbridge.common.assistance.animatronic.Face;
import dev.kleinbox.cccbridge.common.assistance.animatronic.Transition;
import dev.kleinbox.cccbridge.common.computercraft.peripherals.AnimatronicPeripheral;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.PeripheralBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatronicBlockEntity
extends BlockEntity
implements PeripheralBlockEntity {
    private Rotations headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations current_rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_headPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_bodyPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_leftArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Rotations start_rightArmPose = new Rotations(0.0f, 0.0f, 0.0f);
    private Transition transition = Transition.RUSTY;
    private boolean isMoving = true;
    private double step = 0.0;
    private long start_animation = 0L;
    private Face face = Face.NORMAL;
    private AnimatronicPeripheral peripheral;

    public AnimatronicBlockEntity(BlockPos pos, BlockState blockState) {
        super(CCCRegistries.ANIMATRONIC_BLOCK_ENTITY.get(), pos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateCurrentPoses(float partialTicks) {
        this.step = (double)((float)(this.getLevel().getGameTime() - this.start_animation) + partialTicks) * 0.10500000000000001;
        if (this.step >= 1.0) {
            this.isMoving = false;
            this.current_headPose = this.getDestinationHeadPose();
            this.current_bodyPose = this.getDestinationBodyPose();
            this.current_leftArmPose = this.getDestinationLeftArmPose();
            this.current_rightArmPose = this.getDestinationRightArmPose();
        } else {
            switch (this.transition) {
                case RUSTY: {
                    this.current_headPose = this.updateRustyPose(this.start_headPose, this.getDestinationHeadPose(), false);
                    this.current_bodyPose = this.updateRustyPose(this.start_bodyPose, this.getDestinationBodyPose(), true);
                    this.current_leftArmPose = this.updateRustyPose(this.start_leftArmPose, this.getDestinationLeftArmPose(), false);
                    this.current_rightArmPose = this.updateRustyPose(this.start_rightArmPose, this.getDestinationRightArmPose(), false);
                    break;
                }
                case NONE: {
                    this.current_headPose = this.getDestinationHeadPose();
                    this.current_bodyPose = this.getDestinationBodyPose();
                    this.current_leftArmPose = this.getDestinationLeftArmPose();
                    this.current_rightArmPose = this.getDestinationRightArmPose();
                    break;
                }
                case LINEAR: {
                    this.current_headPose = this.updateLinearPose(this.start_headPose, this.getDestinationHeadPose(), false);
                    this.current_bodyPose = this.updateLinearPose(this.start_bodyPose, this.getDestinationBodyPose(), true);
                    this.current_leftArmPose = this.updateLinearPose(this.start_leftArmPose, this.getDestinationLeftArmPose(), false);
                    this.current_rightArmPose = this.updateLinearPose(this.start_rightArmPose, this.getDestinationRightArmPose(), false);
                    break;
                }
                default: {
                    this.setTransition(Transition.RUSTY);
                }
            }
        }
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@NotNull Direction side) {
        if (side.getName().equals(Direction.DOWN.getName())) {
            if (this.peripheral == null) {
                this.peripheral = new AnimatronicPeripheral(this);
            }
            return this.peripheral;
        }
        return null;
    }

    protected void loadAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ListTag ltHead = tag.getList("headPose", 5);
        Rotations headRot = ltHead.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltHead);
        this.setHeadPose(headRot.getX(), headRot.getY(), headRot.getZ());
        ListTag ltBody = tag.getList("bodyPose", 5);
        Rotations bodyRot = ltBody.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltBody);
        this.setBodyPose(bodyRot.getX(), bodyRot.getY(), bodyRot.getZ());
        ListTag ltLeftArm = tag.getList("leftArmPose", 5);
        Rotations leftArmRot = ltLeftArm.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltLeftArm);
        this.setLeftArmPose(leftArmRot.getX(), leftArmRot.getY(), leftArmRot.getZ());
        ListTag ltRightArmPose = tag.getList("rightArmPose", 5);
        Rotations rightArmRot = ltRightArmPose.isEmpty() ? new Rotations(0.0f, 0.0f, 0.0f) : new Rotations(ltRightArmPose);
        this.setRightArmPose(rightArmRot.getX(), rightArmRot.getY(), rightArmRot.getZ());
        @Nullable Face face = Face.contains(tag.getString("face"));
        this.setFace(face != null ? face : Face.NORMAL);
        @Nullable Transition transition = Transition.contains(tag.getString("transition"));
        this.setTransition(transition != null ? transition : Transition.RUSTY);
        super.loadAdditional(tag, registries);
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            this.startAnimation();
        }
    }

    protected void saveAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        tag.put("headPose", (Tag)this.getDestinationHeadPose().save());
        tag.put("bodyPose", (Tag)this.getDestinationBodyPose().save());
        tag.put("leftArmPose", (Tag)this.getDestinationLeftArmPose().save());
        tag.put("rightArmPose", (Tag)this.getDestinationRightArmPose().save());
        if (this.face != null) {
            tag.putString("face", this.face.getId());
        }
        if (this.transition != null) {
            tag.putString("transition", this.transition.getId());
        }
        super.saveAdditional(tag, registries);
    }

    public void setChanged() {
        super.setChanged();
        if (this.getLevel() != null) {
            if (this.getLevel().isClientSide) {
                this.startAnimation();
            } else {
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    private Rotations updateRustyPose(Rotations start, Rotations destination, boolean lazyWay) {
        float x = RustyMovement.updateMovement(start.getX(), destination.getX(), this.step, false);
        float y = RustyMovement.updateMovement(start.getY(), destination.getY(), this.step, lazyWay);
        float z = RustyMovement.updateMovement(start.getZ(), destination.getZ(), this.step, false);
        return new Rotations(x, y, z);
    }

    private Rotations updateLinearPose(Rotations start, Rotations destination, boolean lazyWay) {
        float x = (float)((double)start.getX() + (double)(destination.getX() - start.getX()) * this.step);
        float y = (float)((double)start.getY() + (double)(destination.getY() - start.getY()) * this.step);
        float z = (float)((double)start.getZ() + (double)(destination.getZ() - start.getZ()) * this.step);
        return new Rotations(x, y, z);
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Level getLevel() {
        Level level = super.getLevel();
        if (level == null) {
            level = Minecraft.getInstance().level;
        }
        return level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startAnimation() {
        if (this.getLevel() == null) {
            this.current_headPose = this.getHeadPose();
            this.current_bodyPose = this.getBodyPose();
            this.current_leftArmPose = this.getLeftArmPose();
            this.current_rightArmPose = this.getRightArmPose();
            return;
        }
        this.start_animation = this.getLevel().getGameTime();
        this.start_headPose = this.current_headPose;
        this.start_bodyPose = this.current_bodyPose;
        this.start_leftArmPose = this.current_leftArmPose;
        this.start_rightArmPose = this.current_rightArmPose;
        this.isMoving = true;
        this.step = 0.0;
    }

    public void setFace(Face face) {
        this.face = face;
    }

    public void setTransition(Transition animationMode) {
        this.transition = animationMode;
    }

    public void setRightArmPose(float x, float y, float z) {
        this.rightArmPose = new Rotations(x, y, z);
    }

    public void setLeftArmPose(float x, float y, float z) {
        this.leftArmPose = new Rotations(x, y, z);
    }

    public void setBodyPose(float x, float y, float z) {
        this.bodyPose = new Rotations(x, y, z);
    }

    public void setHeadPose(float x, float y, float z) {
        this.headPose = new Rotations(x, y, z);
    }

    public Face getFace() {
        return this.face;
    }

    public Rotations getRightArmPose() {
        return this.current_rightArmPose;
    }

    public Rotations getLeftArmPose() {
        return this.current_leftArmPose;
    }

    public Rotations getBodyPose() {
        return this.current_bodyPose;
    }

    public Rotations getHeadPose() {
        return this.current_headPose;
    }

    public Rotations getDestinationHeadPose() {
        return this.headPose;
    }

    public Rotations getDestinationBodyPose() {
        return this.bodyPose;
    }

    public Rotations getDestinationLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getDestinationRightArmPose() {
        return this.rightArmPose;
    }
}

