/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.block;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatronicBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IWrenchable {
    public static final BooleanProperty IS_DRIVER = BooleanProperty.create((String)"is_driver");

    public AnimatronicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_DRIVER, (Comparable)Boolean.valueOf(false))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AnimatronicBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter view, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!(blockentity instanceof AnimatronicBlockEntity)) {
            return;
        }
        AnimatronicBlockEntity animatronicBlockEntity = (AnimatronicBlockEntity)blockentity;
        animatronicBlockEntity.setBodyPose(15.0f, 0.0f, 0.0f);
        animatronicBlockEntity.setHeadPose(20.0f, 0.0f, 0.0f);
        animatronicBlockEntity.setRightArmPose(-15.0f, 0.0f, 0.0f);
        animatronicBlockEntity.setLeftArmPose(-15.0f, 0.0f, 0.0f);
        animatronicBlockEntity.setChanged();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState newState = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise());
        return super.onWrenched(newState, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{IS_DRIVER}).add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_DRIVER, (Comparable)Boolean.valueOf(false))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return AnimatronicBlock.simpleCodec(AnimatronicBlock::new);
    }
}

