/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft;

import dev.kleinbox.cccbridge.common.assistance.CharsetManipulator;
import dev.kleinbox.cccbridge.common.modloader.PropertiesBuilder;
import java.text.MessageFormat;
import java.util.List;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TweakedBlockItem
extends BlockItem {
    public static final int TOOLTIP_WIDTH = 25;
    private final double version;

    public TweakedBlockItem(Block block, @Nullable double version) {
        super(block, PropertiesBuilder.PROPERTIES);
        this.version = version;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        String tip = Component.translatable((String)"cccbridge.tooltip.holdForDescription").getString();
        boolean holdsShift = Screen.hasShiftDown();
        tooltipComponents.add((Component)Component.literal((String)MessageFormat.format(tip, holdsShift ? "\u00a7f" : "\u00a77")));
        if (holdsShift) {
            String[] lines;
            tooltipComponents.add((Component)Component.empty());
            for (String line : lines = Component.translatable((String)(super.getDescriptionId() + ".description")).getString().split("\n")) {
                if (line.length() > 25) {
                    for (String sub : CharsetManipulator.wrap(line, 25)) {
                        tooltipComponents.add((Component)Component.literal((String)sub));
                    }
                    continue;
                }
                tooltipComponents.add((Component)Component.literal((String)line));
            }
        }
        if (tooltipFlag.isAdvanced()) {
            if (holdsShift) {
                tooltipComponents.add((Component)Component.empty());
            }
            if (this.version > 0.0) {
                String peripheral = Component.translatable((String)"cccbridge.tooltip.peripheral").getString();
                tooltipComponents.add((Component)Component.literal((String)MessageFormat.format(peripheral, LangNumberFormat.format((double)this.version))));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"cccbridge.tooltip.no_peripheral"));
            }
        }
    }
}

