/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.client.blockEntityRenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.kleinbox.cccbridge.common.assistance.Randomness;
import dev.kleinbox.cccbridge.common.minecraft.block.RedRouterBlock;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.RedRouterBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedRouterBlockEntityRenderer
implements BlockEntityRenderer<RedRouterBlockEntity> {
    private final Map<Integer, ResourceLocation> FACE_TEXTURE;

    public RedRouterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        HashMap<Integer, ResourceLocation> faces = new HashMap<Integer, ResourceLocation>();
        for (int i = 0; i <= 16; ++i) {
            faces.put(i, ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)("block/redrouter/face/" + i)));
        }
        this.FACE_TEXTURE = faces;
    }

    public void render(RedRouterBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState block = blockEntity.getBlockState();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        int flickering = Randomness.lightFlickering();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (block.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            poseStack.mulPose(Axis.YP.rotationDegrees((float)this.getDir((Direction)block.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        int id = 0;
        if (block.hasProperty((Property)RedRouterBlock.FACE)) {
            id = (Integer)block.getValue((Property)RedRouterBlock.FACE);
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(this.getFace(id));
        poseStack.translate(0.0, 0.0, 0.115);
        buffer.addVertex(poseStack.last().pose(), 0.0f, 0.0f, 0.0f).setColor(0.7f, 0.7f, 0.7f, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(flickering).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), 0.0f, 1.0f, 0.0f).setColor(0.7f, 0.7f, 0.7f, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(flickering).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), 1.0f, 1.0f, 0.0f).setColor(0.7f, 0.7f, 0.7f, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(flickering).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last().pose(), 1.0f, 0.0f, 0.0f).setColor(0.7f, 0.7f, 0.7f, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(flickering).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }

    public ResourceLocation getFace(int id) {
        return id >= 1 && id <= 16 ? this.FACE_TEXTURE.get(id) : this.FACE_TEXTURE.get(0);
    }

    public int getDir(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 270;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 90;
            default -> 0;
        };
    }
}

