/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.client.blockEntityRenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kleinbox.cccbridge.client.animatronic.AnimatronicModel;
import dev.kleinbox.cccbridge.common.assistance.Randomness;
import dev.kleinbox.cccbridge.common.minecraft.block.AnimatronicBlock;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AnimatronicBlockEntityRenderer
implements BlockEntityRenderer<AnimatronicBlockEntity> {
    public static final ResourceLocation TEXTURE_BODY = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/body.png");
    public static final ResourceLocation TEXTURE_FACE_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/face_normal.png");
    public static final ResourceLocation TEXTURE_FACE_HAPPY = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/face_happy.png");
    public static final ResourceLocation TEXTURE_FACE_QUESTION = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/face_question.png");
    public static final ResourceLocation TEXTURE_FACE_SAD = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/face_sad.png");
    public static final ResourceLocation TEXTURE_FACE_CURSED = ResourceLocation.fromNamespaceAndPath((String)"cccbridge", (String)"textures/entity/animatronic/face_creepy.png");
    private static final float scale = 0.875f;
    private final AnimatronicModel<AnimatronicBlockEntity> model = new AnimatronicModel(AnimatronicModel.createBodyLayer().bakeRoot());

    public AnimatronicBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull AnimatronicBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.scale(-0.875f, -0.875f, 0.875f);
        poseStack.translate(-0.5666f, -1.5f, 0.5666f);
        this.model.setupAnim(blockEntity, 0.0f, 0.0f, partialTick, 0.0f, 0.0f);
        this.model.hasJob((Boolean)blockEntity.getBlockState().getValue((Property)AnimatronicBlock.IS_DRIVER));
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE_BODY));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        vertexConsumer = bufferSource.getBuffer(this.model.renderType(Randomness.rareCreepiness() ? TEXTURE_FACE_CURSED : AnimatronicModel.getFace(blockEntity)));
        this.model.renderToBuffer(poseStack, vertexConsumer, Randomness.lightFlickering(), OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(AnimatronicBlockEntity blockEntity) {
        return true;
    }
}

