/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public final class TurtleInventoryCrafting {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;

    private TurtleInventoryCrafting() {
    }

    private static @Nullable FoundRecipe tryCrafting(Level level, final Container inventory, final int xStart, final int yStart) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= xStart && x < xStart + 3 && y >= yStart && y < yStart + 3 || inventory.getItem(x + y * 4).isEmpty()) continue;
                return null;
            }
        }
        AbstractList<ItemStack> items = new AbstractList<ItemStack>(){

            @Override
            public ItemStack get(int index) {
                int x = xStart + index % 3;
                int y = yStart + index / 3;
                return x >= 0 && x < 4 && y >= 0 && y < 4 ? inventory.getItem(x + y * 4) : ItemStack.EMPTY;
            }

            @Override
            public int size() {
                return 9;
            }
        };
        CraftingInput input = CraftingInput.of((int)3, (int)3, (List)items);
        RecipeHolder recipe = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level).orElse(null);
        return recipe == null ? null : new FoundRecipe((Recipe<CraftingInput>)recipe.value(), (List<ItemStack>)items, xStart, yStart);
    }

    public static @Nullable List<ItemStack> craft(ITurtleAccess turtle, int maxCount) {
        ItemStack result;
        CraftingInput.Positioned offsetInput;
        CraftingInput input;
        Level level = turtle.getLevel();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return null;
        }
        Container inventory = turtle.getInventory();
        FoundRecipe candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 0, 0);
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 0, 1);
        }
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 1, 0);
        }
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 1, 1);
        }
        if (candidate == null) {
            return null;
        }
        if (maxCount == 0) {
            return List.of();
        }
        Recipe<CraftingInput> recipe = candidate.recipe();
        List<ItemStack> items = candidate.items();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < maxCount && recipe.matches((RecipeInput)(input = (offsetInput = CraftingInput.ofPositioned((int)3, (int)3, items)).input()), level) && !(result = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess())).isEmpty(); ++i) {
            results.add(result);
            result.onCraftedBySystem(level);
            int xStart = candidate.xStart() + offsetInput.left();
            int yStart = candidate.yStart() + offsetInput.top();
            NonNullList remainders = recipe.getRemainingItems((RecipeInput)input);
            for (int y = 0; y < input.height(); ++y) {
                for (int x = 0; x < input.width(); ++x) {
                    int slot = xStart + x + (y + yStart) * 4;
                    ItemStack existing = inventory.getItem(slot);
                    ItemStack remainder = (ItemStack)remainders.get(x + y * input.width());
                    if (!existing.isEmpty()) {
                        inventory.removeItem(slot, 1);
                        existing = inventory.getItem(slot);
                    }
                    if (remainder.isEmpty()) continue;
                    if (existing.isEmpty()) {
                        inventory.setItem(slot, remainder);
                        continue;
                    }
                    if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)remainder)) {
                        existing.grow(remainder.getCount());
                        continue;
                    }
                    results.add(remainder);
                }
            }
        }
        return Collections.unmodifiableList(results);
    }

    private record FoundRecipe(Recipe<CraftingInput> recipe, List<ItemStack> items, int xStart, int yStart) {
    }
}

