/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class MoreStreamCodecs {
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new);
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_INT = new StreamCodec<ByteBuf, OptionalInt>(){

        public OptionalInt decode(ByteBuf buf) {
            return buf.readBoolean() ? OptionalInt.of((Integer)ByteBufCodecs.VAR_INT.decode((Object)buf)) : OptionalInt.empty();
        }

        public void encode(ByteBuf buf, OptionalInt optional) {
            if (optional.isPresent()) {
                buf.writeBoolean(true);
                ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)optional.getAsInt());
            } else {
                buf.writeBoolean(false);
            }
        }
    };
    public static final StreamCodec<ByteBuf, ByteBuffer> BYTE_BUFFER = MoreStreamCodecs.byteBuffer(Integer.MAX_VALUE);

    public static <B extends FriendlyByteBuf, C extends Enum<C>> StreamCodec<B, C> ofEnum(final Class<C> klass) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                return buffer.readEnum(klass);
            }

            public void encode(B buffer, C value) {
                buffer.writeEnum(value);
            }
        };
    }

    public static <B extends FriendlyByteBuf, C> StreamCodec<B, NonNullList<C>> nonNullList(final StreamCodec<B, C> codec, final C empty) {
        return new StreamCodec<B, NonNullList<C>>(){

            public NonNullList<C> decode(B buffer) {
                int count = buffer.readVarInt();
                NonNullList result = NonNullList.withSize((int)count, (Object)empty);
                for (int i = 0; i < result.size(); ++i) {
                    result.set(i, codec.decode(buffer));
                }
                return result;
            }

            public void encode(B buffer, NonNullList<C> list) {
                buffer.writeVarInt(list.size());
                for (Object entry : list) {
                    codec.encode(buffer, entry);
                }
            }
        };
    }

    public static StreamCodec<ByteBuf, ByteBuffer> byteBuffer(final int limit) {
        return new StreamCodec<ByteBuf, ByteBuffer>(){

            public ByteBuffer decode(ByteBuf buf) {
                int toRead = VarInt.read((ByteBuf)buf);
                if (toRead > buf.readableBytes() || toRead >= limit) {
                    throw new DecoderException("ByteArray with size " + toRead + " is bigger than allowed");
                }
                byte[] bytes = new byte[toRead];
                buf.readBytes(bytes);
                return ByteBuffer.wrap(bytes).asReadOnlyBuffer();
            }

            public void encode(ByteBuf buf, ByteBuffer buffer) {
                VarInt.write((ByteBuf)buf, (int)buffer.remaining());
                buf.writeBytes(buffer.duplicate());
            }
        };
    }
}

