/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.Logging;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAPI.class);
    private final IComputerSystem computer;
    private final AdminComputer admin;
    private final OutputReceiver receiver = new OutputReceiver();

    public CommandAPI(IComputerSystem computer, AdminComputer admin) {
        this.computer = computer;
        this.admin = admin;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.computer.getLevel().getServer();
        if (!server.isCommandBlockEnabled()) {
            return new Object[]{false, CommandAPI.createOutput("Command blocks disabled by server")};
        }
        Commands commandManager = server.getCommands();
        try {
            this.receiver.clearOutput();
            CommandState state = new CommandState();
            CommandSourceStack source = this.getSource().withCallback((success, x) -> {
                if (success) {
                    ++state.successes;
                }
            });
            commandManager.performPrefixedCommand(source, command);
            return new Object[]{state.successes > 0, this.receiver.copyOutput(), state.successes};
        }
        catch (Throwable t) {
            LOG.error(Logging.JAVA_ERROR, "Error running command.", t);
            return new Object[]{false, CommandAPI.createOutput("Java Exception Thrown: " + String.valueOf(t))};
        }
    }

    private static Map<?, ?> getBlockInfo(Level world, BlockPos pos) {
        BlockReference block = new BlockReference(world, pos);
        Map<String, Object> table = VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails(block);
        BlockEntity tile = block.blockEntity();
        if (tile != null) {
            table.put("nbt", NBTUtil.toLua((Tag)tile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess())));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public final Object[] exec(String command) {
        return this.doCommand(command);
    }

    @LuaFunction
    public final long execAsync(ILuaContext context, String command) throws LuaException {
        return context.issueMainThreadTask(() -> this.doCommand(command));
    }

    @LuaFunction(mainThread=true)
    public final List<String> list(IArguments args) throws LuaException {
        MinecraftServer server = this.computer.getLevel().getServer();
        RootCommandNode node = server.getCommands().getDispatcher().getRoot();
        for (int j = 0; j < args.count(); ++j) {
            String name = args.getString(j);
            if ((node = node.getChild(name)) instanceof LiteralCommandNode) continue;
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            result.add(child.getName());
        }
        return Collections.unmodifiableList(result);
    }

    @LuaFunction
    public final Object[] getBlockPosition() {
        BlockPos pos = this.computer.getPosition();
        return new Object[]{pos.getX(), pos.getY(), pos.getZ()};
    }

    @LuaFunction(mainThread=true)
    public final List<Map<?, ?>> getBlockInfos(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> dimension) throws LuaException {
        Level world = this.getLevel(dimension);
        BlockPos min = new BlockPos(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        BlockPos max = new BlockPos(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
        if (!world.isInWorldBounds(min) || !world.isInWorldBounds(max)) {
            throw new LuaException("Co-ordinates out of range");
        }
        int blocks = (max.getX() - min.getX() + 1) * (max.getY() - min.getY() + 1) * (max.getZ() - min.getZ() + 1);
        if (blocks > 4096) {
            throw new LuaException("Too many blocks");
        }
        ArrayList results = new ArrayList(blocks);
        for (int y = min.getY(); y <= max.getY(); ++y) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                for (int x = min.getX(); x <= max.getX(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    results.add(CommandAPI.getBlockInfo(world, pos));
                }
            }
        }
        return results;
    }

    @LuaFunction(mainThread=true)
    public final Map<?, ?> getBlockInfo(int x, int y, int z, Optional<String> dimension) throws LuaException {
        BlockPos position;
        Level level = this.getLevel(dimension);
        if (!level.isInWorldBounds(position = new BlockPos(x, y, z))) {
            throw new LuaException("Co-ordinates out of range");
        }
        return CommandAPI.getBlockInfo(level, position);
    }

    private Level getLevel(Optional<String> id) throws LuaException {
        ServerLevel currentLevel = this.computer.getLevel();
        if (id.isEmpty()) {
            return currentLevel;
        }
        ResourceLocation dimensionId = ResourceLocation.tryParse((String)id.get());
        if (dimensionId == null) {
            throw new LuaException("Invalid dimension name");
        }
        ServerLevel level = currentLevel.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionId));
        if (level == null) {
            throw new LuaException("Unknown dimension");
        }
        return level;
    }

    private CommandSourceStack getSource() {
        String name = "@";
        String label = this.computer.getLabel();
        if (label != null) {
            name = label;
        }
        return new CommandSourceStack((CommandSource)this.receiver, Vec3.atCenterOf((Vec3i)this.computer.getPosition()), Vec2.ZERO, this.computer.getLevel(), this.admin.permissionLevel(), name, (Component)Component.literal((String)name), this.computer.getLevel().getServer(), null);
    }

    private final class OutputReceiver
    implements CommandSource {
        private final List<String> output = new ArrayList<String>();

        private OutputReceiver() {
        }

        void clearOutput() {
            this.output.clear();
        }

        List<String> copyOutput() {
            return List.copyOf(this.output);
        }

        public void sendSystemMessage(Component textComponent) {
            this.output.add(textComponent.getString());
        }

        public boolean acceptsSuccess() {
            return true;
        }

        public boolean acceptsFailure() {
            return true;
        }

        public boolean shouldInformAdmins() {
            return CommandAPI.this.computer.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
        }
    }

    private static final class CommandState {
        int successes;

        private CommandState() {
        }
    }
}

