/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.platform;

import com.google.auto.service.AutoService;
import dan200.computercraft.client.ClientTableFormatter;
import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.speaker.EncodedAudio;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jspecify.annotations.Nullable;

@AutoService(value={ClientNetworkContext.class})
public final class ClientNetworkContextImpl
implements ClientNetworkContext {
    @Override
    public void handleChatTable(TableBuilder table) {
        ClientTableFormatter.INSTANCE.display(table);
    }

    @Override
    public void handleComputerTerminal(int containerId, TerminalState terminal) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.containerMenu.containerId == containerId && (abstractContainerMenu = player.containerMenu) instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            menu.updateTerminal(terminal);
        }
    }

    @Override
    public void handleMonitorData(BlockPos pos, @Nullable TerminalState terminal) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        BlockEntity te = player.level().getBlockEntity(pos);
        if (!(te instanceof MonitorBlockEntity)) {
            return;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        monitor.read(terminal);
    }

    @Override
    public void handlePlayRecord(BlockPos pos, @Nullable Holder<JukeboxSong> song) {
        if (song == null) {
            Minecraft.getInstance().levelRenderer.stopJukeboxSongAndNotifyNearby(pos);
        } else {
            Minecraft.getInstance().levelRenderer.playJukeboxSong(song, pos);
        }
    }

    @Override
    public void handlePocketComputerData(UUID instanceId, ComputerState state, int lightState, @Nullable TerminalState terminal) {
        ClientPocketComputers.setState(instanceId, state, lightState, terminal);
    }

    @Override
    public void handlePocketComputerDeleted(UUID instanceId) {
        ClientPocketComputers.remove(instanceId);
    }

    @Override
    public void handleSpeakerAudio(UUID source, SpeakerPosition.Message position, float volume, EncodedAudio buffer) {
        SpeakerManager.getSound(source).playAudio(ClientNetworkContextImpl.reifyPosition(position), volume, buffer);
    }

    @Override
    public void handleSpeakerMove(UUID source, SpeakerPosition.Message position) {
        SpeakerManager.moveSound(source, ClientNetworkContextImpl.reifyPosition(position));
    }

    @Override
    public void handleSpeakerPlay(UUID source, SpeakerPosition.Message position, ResourceLocation sound, float volume, float pitch) {
        SpeakerManager.getSound(source).playSound(ClientNetworkContextImpl.reifyPosition(position), sound, volume, pitch);
    }

    @Override
    public void handleSpeakerStop(UUID source) {
        SpeakerManager.stopSound(source);
    }

    @Override
    public void handleUploadResult(int containerId, UploadResult result, @Nullable Component errorMessage) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = OptionScreen.unwrap(minecraft.screen);
        if (screen instanceof AbstractComputerScreen && ((AbstractComputerMenu)((AbstractComputerScreen)screen).getMenu()).containerId == containerId) {
            ((AbstractComputerScreen)screen).uploadResult(result, errorMessage);
        }
    }

    private static SpeakerPosition reifyPosition(SpeakerPosition.Message pos) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && !level.dimension().location().equals((Object)pos.level())) {
            level = null;
        }
        return new SpeakerPosition((Level)level, pos.position(), level != null && pos.entity().isPresent() ? level.getEntity(pos.entity().getAsInt()) : null);
    }
}

