/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.telemetry.ITelemetry;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;

public class IssueReportScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"betterclouds.gui.issueReport.title");
    private static final Component MESSAGE = Component.translatable((String)"betterclouds.gui.issueReport.message");
    private static final Component TOAST_MESSAGE = Component.translatable((String)"betterclouds.gui.issueReport.toast.sent");
    private static final SystemToast.SystemToastId TOAST_TYPE = new SystemToast.SystemToastId();
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final String details;
    private final Throwable cause;
    private MultiLineTextWidget messageText;

    public IssueReportScreen(Throwable cause, String details) {
        super(TITLE);
        this.details = details;
        this.cause = cause;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.layout.addToHeader((LayoutElement)new StringWidget(this.title, this.font));
        GridLayout body = (GridLayout)this.layout.addToContents((LayoutElement)new GridLayout().rowSpacing(8));
        GridLayout.RowHelper bodyAdder = body.createRowHelper(1);
        MutableComponent text = MutableComponent.create((ComponentContents)MESSAGE.getContents()).append((Component)Component.literal((String)"\n\n")).append((Component)Component.literal((String)this.details).withStyle(style -> style.withColor(ChatFormatting.GRAY)));
        this.messageText = (MultiLineTextWidget)bodyAdder.addChild((LayoutElement)new MultiLineTextWidget((Component)text, this.font).setCentered(true));
        GridLayout footer = (GridLayout)this.layout.addToFooter((LayoutElement)new GridLayout().columnSpacing(5).rowSpacing(5));
        GridLayout.RowHelper footerAdder = footer.createRowHelper(2);
        LayoutSettings positioner = footerAdder.newCellSettings().alignHorizontallyCenter();
        footerAdder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.no"), btn -> this.onClose()).width(100).build(), positioner);
        footerAdder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.yes"), btn -> {
            ITelemetry.INSTANCE.sendIssueReport(CrashReport.forThrowable((Throwable)this.cause, (String)this.details));
            this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)TOAST_TYPE, (Component)Component.nullToEmpty((String)"Better Clouds"), (Component)TOAST_MESSAGE));
            this.onClose();
        }).width(100).build(), positioner);
        footerAdder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"betterclouds.gui.issueReport.disable"), btn -> {
            ConfigManager.instance().issueReportEnabled = false;
            ConfigManager.handler().save();
            this.onClose();
        }).width(205).build(), 2, positioner);
        footer.arrangeElements();
        this.layout.setFooterHeight(footer.getHeight() + 13);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.refreshWidgetPositions();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void resize(Minecraft client, int width, int height) {
        super.resize(client, width, height);
        this.refreshWidgetPositions();
    }

    protected void refreshWidgetPositions() {
        this.messageText.setMaxWidth(this.width - 50);
        this.messageText.setWidth(this.width - 50);
        this.layout.arrangeElements();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        super.render(context, mouseX, mouseY, deltaTicks);
    }
}

