/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.google.common.base.Objects;
import com.google.gson.InstanceCreator;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import org.jetbrains.annotations.Nullable;

public class ShaderPresetConfig {
    public static final InstanceCreator<ShaderPresetConfig> INSTANCE_CREATOR = type -> new ShaderPresetConfig();
    protected static final ShaderPresetConfig EMPTY_PRESET = new ShaderPresetConfig();
    @SerialEntry
    public String title;
    @SerialEntry
    @Nullable
    public String key;
    @SerialEntry
    public boolean editable = true;
    @SerialEntry
    public float upscaleResolutionFactor = 1.0f;
    @SerialEntry
    public float gamma = 1.0f;
    @SerialEntry
    public float sunPathAngle = 0.0f;
    @SerialEntry
    public int sunriseStartTime = -785;
    @SerialEntry
    public int sunriseEndTime = 1163;
    @SerialEntry
    public int sunsetStartTime = 10837;
    @SerialEntry
    public int sunsetEndTime = 12785;
    @SerialEntry
    public float dayBrightness = 1.0f;
    @SerialEntry
    public float nightBrightness = 1.0f;
    @SerialEntry
    public float saturation = 1.0f;
    @SerialEntry
    public float opacity = 0.2f;
    @SerialEntry
    public float opacityFactor = 1.0f;
    @SerialEntry
    public float opacityExponent = 1.5f;
    @SerialEntry
    public float tintRed = 1.0f;
    @SerialEntry
    public float tintGreen = 1.0f;
    @SerialEntry
    public float tintBlue = 1.0f;
    @SerialEntry
    public int worldCurvatureSize = 0;

    public ShaderPresetConfig() {
        this("");
    }

    public ShaderPresetConfig(String title) {
        this.title = title;
    }

    public ShaderPresetConfig(ShaderPresetConfig other) {
        this.title = other.title;
        this.key = other.key;
        this.editable = other.editable;
        this.upscaleResolutionFactor = other.upscaleResolutionFactor;
        this.gamma = other.gamma;
        this.sunPathAngle = other.sunPathAngle;
        this.dayBrightness = other.dayBrightness;
        this.nightBrightness = other.nightBrightness;
        this.sunriseStartTime = other.sunriseStartTime;
        this.sunriseEndTime = other.sunriseEndTime;
        this.sunsetStartTime = other.sunsetStartTime;
        this.sunsetEndTime = other.sunsetEndTime;
        this.saturation = other.saturation;
        this.opacity = other.opacity;
        this.opacityFactor = other.opacityFactor;
        this.opacityExponent = other.opacityExponent;
        this.tintRed = other.tintRed;
        this.tintGreen = other.tintGreen;
        this.tintBlue = other.tintBlue;
        this.worldCurvatureSize = other.worldCurvatureSize;
    }

    public float gamma() {
        if (this.gamma > 0.0f) {
            return this.gamma;
        }
        return -1.0f / this.gamma;
    }

    public void markAsCopy() {
        this.editable = true;
        this.key = null;
    }

    public boolean isEqualTo(ShaderPresetConfig other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.editable == other.editable && Float.compare(other.upscaleResolutionFactor, this.upscaleResolutionFactor) == 0 && Float.compare(other.gamma, this.gamma) == 0 && Float.compare(other.sunPathAngle, this.sunPathAngle) == 0 && this.sunriseStartTime == other.sunriseStartTime && this.sunriseEndTime == other.sunriseEndTime && this.sunsetStartTime == other.sunsetStartTime && this.sunsetEndTime == other.sunsetEndTime && Float.compare(other.dayBrightness, this.dayBrightness) == 0 && Float.compare(other.nightBrightness, this.nightBrightness) == 0 && Float.compare(other.saturation, this.saturation) == 0 && Float.compare(other.opacity, this.opacity) == 0 && Float.compare(other.opacityFactor, this.opacityFactor) == 0 && Float.compare(other.opacityExponent, this.opacityExponent) == 0 && Float.compare(other.tintRed, this.tintRed) == 0 && Float.compare(other.tintGreen, this.tintGreen) == 0 && Float.compare(other.tintBlue, this.tintBlue) == 0 && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.key, (Object)other.key) && this.worldCurvatureSize == other.worldCurvatureSize;
    }
}

