/*
 * Decompiled with CFR 0.152.
 */
package net.cerealcamera.aviator_dream.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import net.cerealcamera.aviator_dream.AviatorDreams;
import net.cerealcamera.aviator_dream.Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FVIIAEntity
extends AirplaneEntity {
    public boolean shuttingDown = false;
    public byte durationHigh = 0;
    public byte durationLow = 0;
    private float reactionSpeed = 200.0f;

    public FVIIAEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    protected SoundEvent getEngineSound() {
        return SoundEvents.EMPTY;
    }

    protected SoundEvent getEngineStartSound() {
        return Sounds.LYNX_START.get();
    }

    protected float getEngineReactionSpeed() {
        return this.reactionSpeed;
    }

    public Item asItem() {
        return AviatorDreams.FVIIA_ITEM.get();
    }

    public void tick() {
        super.tick();
        this.reactionSpeed = this.getEngineTarget() == 0.0f ? 200.0f : 200.0f;
        if (this.getEngineTarget() == 0.0f && this.shuttingDown) {
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), Sounds.LYNX_STOP.get(), this.getSoundSource(), 1.0f, 1.0f, false);
            this.shuttingDown = false;
        }
        if (this.getEngineTarget() > 0.0f) {
            this.shuttingDown = true;
        }
        if (this.level().isClientSide) {
            if (this.durationLow > 0) {
                this.durationLow = (byte)(this.durationLow - 1);
            } else if (this.durationLow == 0 && (double)this.getEngineTarget() <= 0.25 && this.getEngineTarget() != 0.0f && this.getFuelUtilization() != 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), Sounds.LYNX_IDLE.get(), this.getSoundSource(), 1.0f, 1.0f, false);
                this.durationLow = (byte)59;
            }
            if (this.durationHigh > 0) {
                this.durationHigh = (byte)(this.durationHigh - 1);
            } else if (this.durationHigh == 0 && (double)this.getEngineTarget() > 0.25 && this.getEngineTarget() != 0.0f && this.getFuelUtilization() != 0.0f) {
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), Sounds.LYNX_HIGH.get(), this.getSoundSource(), 1.0f, 1.0f, false);
                this.durationHigh = (byte)37;
            }
        }
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.1f);
    }

    public double getZoom() {
        return 18.0;
    }

    public int getDefaultDyeColor() {
        return 15672099;
    }
}

