/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.model;

import com.google.common.collect.ImmutableMap;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.block.model.SlopeBakedModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SlopeUnbakedModel
implements UnbakedModel {
    public static final ResourceLocation MODEL_SLOPE_BOTTOM = Automobility.rl("block/slope_bottom");
    public static final ResourceLocation MODEL_SLOPE_TOP = Automobility.rl("block/slope_top");
    public static final ResourceLocation MODEL_STEEP_SLOPE = Automobility.rl("block/steep_slope");
    public static final ResourceLocation MODEL_SLOPE_BOTTOM_DASH_PANEL = Automobility.rl("block/slope_bottom_dash_panel");
    public static final ResourceLocation MODEL_SLOPE_TOP_DASH_PANEL = Automobility.rl("block/slope_top_dash_panel");
    public static final ResourceLocation MODEL_STEEP_SLOPE_DASH_PANEL = Automobility.rl("block/steep_slope_dash_panel");
    public static final ResourceLocation MODEL_SLOPE_BOTTOM_DASH_PANEL_OFF = Automobility.rl("block/slope_bottom_dash_panel_off");
    public static final ResourceLocation MODEL_SLOPE_TOP_DASH_PANEL_OFF = Automobility.rl("block/slope_top_dash_panel_off");
    public static final ResourceLocation MODEL_STEEP_SLOPE_DASH_PANEL_OFF = Automobility.rl("block/steep_slope_dash_panel_off");
    public static final ResourceLocation TEX_FRAME = Automobility.rl("block/slope_frame");
    public static final ResourceLocation TEX_DASH_PANEL = Automobility.rl("block/dash_panel");
    public static final ResourceLocation TEX_DASH_PANEL_OFF = Automobility.rl("block/dash_panel_off");
    public static final ResourceLocation TEX_DASH_PANEL_FRAME = Automobility.rl("block/dash_panel_frame");
    public static final Map<ResourceLocation, Supplier<SlopeUnbakedModel>> DEFAULT_MODELS = ImmutableMap.of((Object)MODEL_SLOPE_TOP, () -> new SlopeUnbakedModel(Type.TOP, TEX_FRAME, null, null), (Object)MODEL_SLOPE_BOTTOM, () -> new SlopeUnbakedModel(Type.BOTTOM, TEX_FRAME, null, null), (Object)MODEL_STEEP_SLOPE, () -> new SlopeUnbakedModel(Type.STEEP, TEX_FRAME, null, null), (Object)MODEL_SLOPE_TOP_DASH_PANEL, () -> new SlopeUnbakedModel(Type.TOP, TEX_FRAME, TEX_DASH_PANEL, TEX_DASH_PANEL_FRAME), (Object)MODEL_SLOPE_BOTTOM_DASH_PANEL, () -> new SlopeUnbakedModel(Type.BOTTOM, TEX_FRAME, TEX_DASH_PANEL, TEX_DASH_PANEL_FRAME), (Object)MODEL_STEEP_SLOPE_DASH_PANEL, () -> new SlopeUnbakedModel(Type.STEEP, TEX_FRAME, TEX_DASH_PANEL, TEX_DASH_PANEL_FRAME), (Object)MODEL_SLOPE_TOP_DASH_PANEL_OFF, () -> new SlopeUnbakedModel(Type.TOP, TEX_FRAME, TEX_DASH_PANEL_OFF, TEX_DASH_PANEL_FRAME), (Object)MODEL_SLOPE_BOTTOM_DASH_PANEL_OFF, () -> new SlopeUnbakedModel(Type.BOTTOM, TEX_FRAME, TEX_DASH_PANEL_OFF, TEX_DASH_PANEL_FRAME), (Object)MODEL_STEEP_SLOPE_DASH_PANEL_OFF, () -> new SlopeUnbakedModel(Type.STEEP, TEX_FRAME, TEX_DASH_PANEL_OFF, TEX_DASH_PANEL_FRAME));
    private static final ResourceLocation PARENT = ResourceLocation.parse((String)"block/block");
    private final Type type;
    private final Material frameTex;
    @Nullable
    private final Material plateInnerTex;
    @Nullable
    private final Material plateOuterTex;

    public SlopeUnbakedModel(Type type, ResourceLocation frameTex, @Nullable ResourceLocation plateInnerTex, @Nullable ResourceLocation plateOuterTex) {
        this.type = type;
        this.frameTex = new Material(TextureAtlas.LOCATION_BLOCKS, frameTex);
        this.plateInnerTex = plateInnerTex != null ? new Material(TextureAtlas.LOCATION_BLOCKS, plateInnerTex) : null;
        this.plateOuterTex = plateOuterTex != null ? new Material(TextureAtlas.LOCATION_BLOCKS, plateOuterTex) : null;
    }

    public Collection<ResourceLocation> getDependencies() {
        return List.of(PARENT);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
    }

    private static Map<BlockState, TextureAtlasSprite> createFrameTexOverrides(Function<Material, TextureAtlasSprite> spriteGet) {
        return ImmutableMap.of((Object)Blocks.GRASS_BLOCK.defaultBlockState(), (Object)SlopeUnbakedModel.vanillaSprite(spriteGet, "block/grass_block_top"), (Object)Blocks.PODZOL.defaultBlockState(), (Object)SlopeUnbakedModel.vanillaSprite(spriteGet, "block/podzol_top"), (Object)Blocks.MYCELIUM.defaultBlockState(), (Object)SlopeUnbakedModel.vanillaSprite(spriteGet, "block/mycelium_top"), (Object)Blocks.CRIMSON_NYLIUM.defaultBlockState(), (Object)SlopeUnbakedModel.vanillaSprite(spriteGet, "block/crimson_nylium"), (Object)Blocks.WARPED_NYLIUM.defaultBlockState(), (Object)SlopeUnbakedModel.vanillaSprite(spriteGet, "block/warped_nylium"));
    }

    @Nullable
    public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state) {
        return SlopeBakedModel.impl.create(spriteGetter.apply(this.frameTex), SlopeUnbakedModel.createFrameTexOverrides(spriteGetter), this.plateInnerTex != null ? spriteGetter.apply(this.plateInnerTex) : null, this.plateOuterTex != null ? spriteGetter.apply(this.plateOuterTex) : null, state, this.type);
    }

    private static TextureAtlasSprite vanillaSprite(Function<Material, TextureAtlasSprite> spriteGet, String name) {
        return spriteGet.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)name)));
    }

    public static enum Type {
        BOTTOM,
        TOP,
        STEEP;

    }
}

