/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.impl;

import com.google.common.base.Suppliers;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NetworkAggregator {
    public static final Supplier<Adaptor> ADAPTOR = Suppliers.memoize(() -> {
        try {
            Method adaptor = NetworkManager.class.getDeclaredMethod("getAdaptor", new Class[0]);
            adaptor.setAccessible(true);
            return (Adaptor)adaptor.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    });
    public static final Map<ResourceLocation, CustomPacketPayload.Type<BufCustomPacketPayload>> C2S_TYPE = new HashMap<ResourceLocation, CustomPacketPayload.Type<BufCustomPacketPayload>>();
    public static final Map<ResourceLocation, CustomPacketPayload.Type<BufCustomPacketPayload>> S2C_TYPE = new HashMap<ResourceLocation, CustomPacketPayload.Type<BufCustomPacketPayload>>();
    public static final Map<ResourceLocation, NetworkManager.NetworkReceiver<?>> C2S_RECEIVER = new HashMap();
    public static final Map<ResourceLocation, NetworkManager.NetworkReceiver<?>> S2C_RECEIVER = new HashMap();
    public static final Map<ResourceLocation, StreamCodec<ByteBuf, ?>> C2S_CODECS = new HashMap();
    public static final Map<ResourceLocation, StreamCodec<ByteBuf, ?>> S2C_CODECS = new HashMap();
    public static final Map<ResourceLocation, PacketTransformer> C2S_TRANSFORMERS = new HashMap<ResourceLocation, PacketTransformer>();
    public static final Map<ResourceLocation, PacketTransformer> S2C_TRANSFORMERS = new HashMap<ResourceLocation, PacketTransformer>();

    public static void registerReceiver(NetworkManager.Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver<RegistryFriendlyByteBuf> receiver) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(id);
        if (side == NetworkManager.Side.C2S) {
            C2S_TYPE.put(id, (CustomPacketPayload.Type<BufCustomPacketPayload>)type);
            NetworkAggregator.registerC2SReceiver(type, BufCustomPacketPayload.streamCodec((CustomPacketPayload.Type<BufCustomPacketPayload>)type), packetTransformers, (value, context) -> {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])value.payload()), context.registryAccess());
                receiver.receive(buf, context);
                buf.release();
            });
        } else if (side == NetworkManager.Side.S2C) {
            S2C_TYPE.put(id, (CustomPacketPayload.Type<BufCustomPacketPayload>)type);
            NetworkAggregator.registerS2CReceiver(type, BufCustomPacketPayload.streamCodec((CustomPacketPayload.Type<BufCustomPacketPayload>)type), packetTransformers, (value, context) -> {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])value.payload()), context.registryAccess());
                receiver.receive(buf, context);
                buf.release();
            });
        }
    }

    public static <T extends CustomPacketPayload> void registerReceiver(NetworkManager.Side side, CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver<T> receiver) {
        Objects.requireNonNull(type, "Cannot register receiver with a null type!");
        packetTransformers = Objects.requireNonNullElse(packetTransformers, List.of());
        Objects.requireNonNull(receiver, "Cannot register a null receiver!");
        if (side == NetworkManager.Side.C2S) {
            NetworkAggregator.registerC2SReceiver(type, codec, packetTransformers, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkAggregator.registerS2CReceiver(type, codec, packetTransformers, receiver);
        }
    }

    private static <T extends CustomPacketPayload> void registerC2SReceiver(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver<T> receiver) {
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        C2S_RECEIVER.put(type.id(), receiver);
        C2S_CODECS.put(type.id(), codec);
        C2S_TRANSFORMERS.put(type.id(), transformer);
        ADAPTOR.get().registerC2S(type, BufCustomPacketPayload.streamCodec(type), (payload, context) -> {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.payload()), context.registryAccess());
            transformer.inbound(NetworkManager.Side.C2S, type.id(), buf, context, (side, id1, buf1) -> {
                NetworkManager.NetworkReceiver<?> networkReceiver;
                NetworkManager.NetworkReceiver<?> networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S_RECEIVER.get(id1) : S2C_RECEIVER.get(id1);
                if (networkReceiver == null) {
                    throw new IllegalArgumentException("Network Receiver not found! " + String.valueOf(id1));
                }
                CustomPacketPayload actualPayload = (CustomPacketPayload)codec.decode((Object)buf1);
                networkReceiver.receive(actualPayload, context);
            });
            buf.release();
        });
    }

    private static <T extends CustomPacketPayload> void registerS2CReceiver(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver<T> receiver) {
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        S2C_RECEIVER.put(type.id(), receiver);
        S2C_CODECS.put(type.id(), codec);
        S2C_TRANSFORMERS.put(type.id(), transformer);
        ADAPTOR.get().registerS2C(type, BufCustomPacketPayload.streamCodec(type), (payload, context) -> {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.payload()), context.registryAccess());
            transformer.inbound(NetworkManager.Side.S2C, type.id(), buf, context, (side, id1, buf1) -> {
                NetworkManager.NetworkReceiver<?> networkReceiver;
                NetworkManager.NetworkReceiver<?> networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S_RECEIVER.get(id1) : S2C_RECEIVER.get(id1);
                if (networkReceiver == null) {
                    throw new IllegalArgumentException("Network Receiver not found! " + String.valueOf(id1));
                }
                CustomPacketPayload actualPayload = (CustomPacketPayload)codec.decode((Object)buf1);
                networkReceiver.receive(actualPayload, context);
            });
            buf.release();
        });
    }

    public static void collectPackets(PacketSink sink, NetworkManager.Side side, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        if (side == NetworkManager.Side.C2S) {
            NetworkAggregator.collectPackets(sink, side, new BufCustomPacketPayload(C2S_TYPE.get(id), ByteBufUtil.getBytes((ByteBuf)buf)), buf.registryAccess());
        } else {
            NetworkAggregator.collectPackets(sink, side, new BufCustomPacketPayload(S2C_TYPE.get(id), ByteBufUtil.getBytes((ByteBuf)buf)), buf.registryAccess());
        }
    }

    public static <T extends CustomPacketPayload> void collectPackets(PacketSink sink, NetworkManager.Side side, T payload, RegistryAccess access) {
        CustomPacketPayload.Type type = payload.type();
        PacketTransformer transformer = side == NetworkManager.Side.C2S ? C2S_TRANSFORMERS.get(type.id()) : S2C_TRANSFORMERS.get(type.id());
        StreamCodec<ByteBuf, ?> codec = side == NetworkManager.Side.C2S ? C2S_CODECS.get(type.id()) : S2C_CODECS.get(type.id());
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), access);
        codec.encode((Object)buf, payload);
        if (transformer != null) {
            transformer.outbound(side, type.id(), buf, (side1, id1, buf1) -> {
                if (side == NetworkManager.Side.C2S) {
                    CustomPacketPayload.Type<BufCustomPacketPayload> type1 = C2S_TYPE.getOrDefault(id1, (CustomPacketPayload.Type<BufCustomPacketPayload>)type);
                    sink.accept(NetworkAggregator.toPacket(side1, new BufCustomPacketPayload(type1, ByteBufUtil.getBytes((ByteBuf)buf1))));
                } else if (side == NetworkManager.Side.S2C) {
                    CustomPacketPayload.Type<BufCustomPacketPayload> type1 = S2C_TYPE.getOrDefault(id1, (CustomPacketPayload.Type<BufCustomPacketPayload>)type);
                    sink.accept(NetworkAggregator.toPacket(side1, new BufCustomPacketPayload(type1, ByteBufUtil.getBytes((ByteBuf)buf1))));
                }
            });
        } else {
            sink.accept(NetworkAggregator.toPacket(side, new BufCustomPacketPayload((CustomPacketPayload.Type<BufCustomPacketPayload>)type, ByteBufUtil.getBytes((ByteBuf)buf))));
        }
        buf.release();
    }

    public static <T extends CustomPacketPayload> Packet<?> toPacket(NetworkManager.Side side, T payload) {
        if (side == NetworkManager.Side.C2S) {
            return ADAPTOR.get().toC2SPacket(payload);
        }
        if (side == NetworkManager.Side.S2C) {
            return ADAPTOR.get().toS2CPacket(payload);
        }
        throw new IllegalArgumentException("Invalid side: " + String.valueOf((Object)side));
    }

    public static void registerS2CType(ResourceLocation id, List<PacketTransformer> packetTransformers) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(id);
        S2C_TYPE.put(id, (CustomPacketPayload.Type<BufCustomPacketPayload>)type);
        NetworkAggregator.registerS2CType(type, BufCustomPacketPayload.streamCodec((CustomPacketPayload.Type<BufCustomPacketPayload>)type), packetTransformers);
    }

    public static <T extends CustomPacketPayload> void registerS2CType(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers) {
        Objects.requireNonNull(type, "Cannot register a null type!");
        packetTransformers = Objects.requireNonNullElse(packetTransformers, List.of());
        S2C_CODECS.put(type.id(), codec);
        S2C_TRANSFORMERS.put(type.id(), PacketTransformer.concat(packetTransformers));
        ADAPTOR.get().registerS2CType(type, BufCustomPacketPayload.streamCodec(type));
    }

    public record BufCustomPacketPayload(CustomPacketPayload.Type<BufCustomPacketPayload> _type, byte[] payload) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this._type();
        }

        public static StreamCodec<ByteBuf, BufCustomPacketPayload> streamCodec(CustomPacketPayload.Type<BufCustomPacketPayload> type) {
            return ByteBufCodecs.BYTE_ARRAY.map(bytes -> new BufCustomPacketPayload(type, (byte[])bytes), BufCustomPacketPayload::payload);
        }
    }

    public static interface Adaptor {
        public <T extends CustomPacketPayload> void registerC2S(CustomPacketPayload.Type<T> var1, StreamCodec<? super RegistryFriendlyByteBuf, T> var2, NetworkManager.NetworkReceiver<T> var3);

        public <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> var1, StreamCodec<? super RegistryFriendlyByteBuf, T> var2, NetworkManager.NetworkReceiver<T> var3);

        public <T extends CustomPacketPayload> Packet<?> toC2SPacket(T var1);

        public <T extends CustomPacketPayload> Packet<?> toS2CPacket(T var1);

        public <T extends CustomPacketPayload> void registerS2CType(CustomPacketPayload.Type<T> var1, StreamCodec<? super RegistryFriendlyByteBuf, T> var2);
    }
}

