/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.StoneVariants;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class StoneVariantsImpl
implements StoneVariants {
    private static final Pattern ORE_TAG_PATTERN = Pattern.compile("(c:ores/.+|(minecraft|c):.+_ores)");
    private final Map<TagKey<Item>, Boolean> isOreTagCache = new HashMap<TagKey<Item>, Boolean>();
    private final List<String> stoneVariants;
    private final Map<ResourceLocation, String> itemToStoneVariant;

    private StoneVariantsImpl(Collection<String> stoneVariants, Map<ResourceLocation, String> itemToStoneVariant) {
        this.stoneVariants = StoneVariantsImpl.sortStoneVariants(stoneVariants);
        this.itemToStoneVariant = itemToStoneVariant;
    }

    public static StoneVariants create(Collection<String> stoneVariants, VanillaTagWrapper<Item> itemTags, VanillaTagWrapper<Block> blockTags) {
        TagKey<Item> tag;
        ResourceLocation item;
        HashSet stoneVariantItemTags = new HashSet();
        HashSet stoneVariantBlockTags = new HashSet();
        for (String stoneVariant : stoneVariants) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores_in_ground/" + stoneVariant));
            stoneVariantItemTags.add(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id));
            stoneVariantBlockTags.add(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id));
        }
        Map<ResourceLocation, TagKey<Item>> itemToStoneVariantTag = StoneVariantsImpl.mapEntriesToStoneVariantTags(stoneVariantItemTags, itemTags);
        Map<ResourceLocation, TagKey<Block>> blockToStoneVariantTag = StoneVariantsImpl.mapEntriesToStoneVariantTags(stoneVariantBlockTags, blockTags);
        HashMap<ResourceLocation, String> itemToStoneVariant = new HashMap<ResourceLocation, String>();
        for (Map.Entry<ResourceLocation, TagKey<Item>> entry : itemToStoneVariantTag.entrySet()) {
            item = entry.getKey();
            tag = entry.getValue();
            String itemTagStoneVariant = StoneVariantsImpl.getVariantFromStoneVariantTag(stoneVariants, tag);
            if (itemTagStoneVariant == null) continue;
            itemToStoneVariant.put(item, itemTagStoneVariant);
        }
        for (Map.Entry<ResourceLocation, TagKey<Item>> entry : blockToStoneVariantTag.entrySet()) {
            String itemTagStoneVariant;
            item = entry.getKey();
            tag = entry.getValue();
            String blockTagStoneVariant = StoneVariantsImpl.getVariantFromStoneVariantTag(stoneVariants, tag);
            if (blockTagStoneVariant == null || (itemTagStoneVariant = (String)itemToStoneVariant.get(item)) != null && blockTagStoneVariant.length() <= itemTagStoneVariant.length()) continue;
            itemToStoneVariant.put(item, blockTagStoneVariant);
        }
        return new StoneVariantsImpl(stoneVariants, itemToStoneVariant);
    }

    private static <T> Map<ResourceLocation, TagKey<T>> mapEntriesToStoneVariantTags(Set<TagKey<T>> stoneVariantTags, VanillaTagWrapper<T> tags) {
        HashMap<ResourceLocation, TagKey<T>> idToStoneVariantTag = new HashMap<ResourceLocation, TagKey<T>>();
        for (TagKey<T> stoneVariantTag : stoneVariantTags) {
            for (Holder holder : tags.get(stoneVariantTag)) {
                ResourceLocation id = ((ResourceKey)holder.unwrapKey().orElseThrow(() -> new IllegalStateException("Tag is not bound for holder " + String.valueOf(holder)))).location();
                TagKey<T> oldTag = idToStoneVariantTag.put(id, stoneVariantTag);
                if (oldTag == null) continue;
                AlmostUnifiedCommon.LOGGER.error("{} is bound to multiple stone variant tags: {} and {}", (Object)id, oldTag, stoneVariantTag);
            }
        }
        return idToStoneVariantTag;
    }

    @Nullable
    private static String getVariantFromStoneVariantTag(Collection<String> stoneVariants, TagKey<?> tag) {
        int i;
        String tagString = tag.location().toString();
        String stoneVariant = tagString.substring((i = tagString.lastIndexOf(47)) + 1);
        if (!stoneVariants.contains(stoneVariant)) {
            return null;
        }
        return stoneVariant.equals("stone") ? "" : stoneVariant;
    }

    @Override
    public String getStoneVariant(ResourceLocation item) {
        return this.itemToStoneVariant.computeIfAbsent(item, this::computeStoneVariant);
    }

    @Override
    public boolean isOreTag(TagKey<Item> tag) {
        return this.isOreTagCache.computeIfAbsent(tag, t -> ORE_TAG_PATTERN.matcher(t.location().toString()).matches());
    }

    private static List<String> sortStoneVariants(Collection<String> stoneVariants) {
        return stoneVariants.stream().sorted(Comparator.comparingInt(String::length).reversed()).toList();
    }

    private String computeStoneVariant(ResourceLocation item) {
        for (String stoneVariant : this.stoneVariants) {
            if (!item.getPath().contains(stoneVariant + "_") && !item.getPath().endsWith("_" + stoneVariant)) continue;
            return stoneVariant.equals("stone") ? "" : stoneVariant;
        }
        return "";
    }
}

