/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Bridges {
    public static final String modid = "mcwbridges";
    public static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties WOOD = BlockBehaviour.Properties.of().strength(0.5f, 2.5f).sound(SoundType.WOOD);
        Bridges.setRegistrationWoodModLoaded(set, block, item, WOOD);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties STONE = BlockBehaviour.Properties.of().strength(3.0f, 5.0f).sound(SoundType.STONE);
        Bridges.setRegistrationRockModLoaded(set, block, item, STONE);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new Block(STONE), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new Block(WOOD), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block log_bridge_middle = Finder.findBlock(MODID, i + "_log_bridge_middle");
                Block rope_bridge = Finder.findBlock(MODID, "rope_" + i + "_bridge");
                Block bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block log_bridge_stair = Finder.findBlock(MODID, i + "_log_bridge_stair");
                Block rope_bridge_stair = Finder.findBlock(MODID, i + "_rope_bridge_stair");
                Block rail_bridge = Finder.findBlock(MODID, i + "_rail_bridge");
                event.accept((ItemLike)log_bridge_middle);
                event.accept((ItemLike)rope_bridge);
                event.accept((ItemLike)bridge_pier);
                event.accept((ItemLike)log_bridge_stair);
                event.accept((ItemLike)rope_bridge_stair);
                event.accept((ItemLike)rail_bridge);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : STONE) {
                Block stone_bridge = Finder.findBlock(MODID, i + "_bridge");
                Block stone_bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block stone_bridge_stair = Finder.findBlock(MODID, i + "_bridge_stair");
                Block balustrade_stone_bridge = Finder.findBlock(MODID, "balustrade_" + i + "_bridge");
                event.accept((ItemLike)stone_bridge);
                event.accept((ItemLike)stone_bridge_pier);
                event.accept((ItemLike)stone_bridge_stair);
                event.accept((ItemLike)balustrade_stone_bridge);
            }
        }
    }
}

