/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.registry.BrewingRegistry;
import org.violetmoon.zetaimplforge.ForgeZeta;

public class ForgeBrewingRegistry
extends BrewingRegistry {
    private List<DelayedPotion> delayedPotions = new ArrayList<DelayedPotion>();
    private boolean okToRegisterImmediately = false;

    public ForgeBrewingRegistry(ForgeZeta zeta) {
        super(zeta);
    }

    @Override
    public void addBrewingRecipe(Potion input, Item reagentSupplier, Potion output) {
        DelayedPotion d = new DelayedPotion((Holder<Potion>)Holder.direct((Object)input), reagentSupplier, (Holder<Potion>)Holder.direct((Object)output));
        if (this.okToRegisterImmediately) {
            d.register();
        } else {
            this.delayedPotions.add(d);
        }
    }

    @LoadEvent
    public void commonSetup(ZCommonSetup event) {
        event.enqueueWork(() -> {
            this.okToRegisterImmediately = true;
            if (this.delayedPotions != null) {
                this.delayedPotions.forEach(DelayedPotion::register);
            }
            this.delayedPotions = null;
        });
    }

    private record DelayedPotion(Holder<Potion> input, Item reagentSupplier, Holder<Potion> output) {
        void register() {
            new PotionBrewing.Builder(FeatureFlagSet.of()).addMix(this.input, this.reagentSupplier, this.output);
        }
    }
}

