/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.violetmoon.zeta.config.IZetaConfigInternals;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class ForgeBackedConfig
implements IZetaConfigInternals {
    private final Map<ValueDefinition<?>, ModConfigSpec.ConfigValue<?>> definitionsToValues = new HashMap();
    private long debounceTime = System.currentTimeMillis();

    public ForgeBackedConfig(SectionDefinition rootSection, ModConfigSpec.Builder forgeBuilder) {
        this.walkSection(rootSection, forgeBuilder, true);
    }

    private void walkSection(SectionDefinition sect, ModConfigSpec.Builder builder, boolean root) {
        if (!root) {
            builder.comment(sect.commentToArray());
            builder.push(sect.name);
        }
        for (ValueDefinition<?> value : sect.getValues()) {
            this.addValue(value, builder);
        }
        for (SectionDefinition subsection : sect.getSubsections()) {
            this.walkSection(subsection, builder, false);
        }
        if (!root) {
            builder.pop();
        }
    }

    private <T> void addValue(ValueDefinition<T> val, ModConfigSpec.Builder builder) {
        ModConfigSpec.ConfigValue forge;
        builder.comment(val.commentToArray());
        Object t = val.defaultValue;
        if (t instanceof List) {
            List list = (List)t;
            forge = builder.defineList(val.name, list, val::validate);
        } else {
            forge = builder.define(List.of(val.name), () -> val.defaultValue, val::validate, val.defaultValue.getClass());
        }
        this.definitionsToValues.put(val, forge);
    }

    @Override
    public <T> T get(ValueDefinition<T> definition) {
        ModConfigSpec.ConfigValue<?> forge = this.definitionsToValues.get(definition);
        return (T)forge.get();
    }

    @Override
    public <T> void set(ValueDefinition<T> definition, T value) {
        ModConfigSpec.ConfigValue<?> forge = this.definitionsToValues.get(definition);
        this.debounceTime = System.currentTimeMillis();
        forge.set(value);
    }

    @Override
    public void flush() {
        this.definitionsToValues.values().iterator().next().save();
    }
}

