/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.config;

import java.util.concurrent.atomic.AtomicInteger;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.util.ZetaSide;
import org.violetmoon.zetaimplforge.event.load.ForgeZConfigChange;

public class ConfigEventDispatcher {
    private final Zeta z;
    private static final int BEFORE_INIT = 0;
    private static final int WAITING_FOR_SERVER_START = 1;
    private static final int ACCEPT_FILE_RELOADS = 2;
    private static final int BUSY = 3;
    private final AtomicInteger state = new AtomicInteger(0);

    public ConfigEventDispatcher(Zeta z) {
        this.z = z;
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            int oldState;
            this.z.log.info("Common setup: Performing initial refresh of {}'s config on thread '{}'", (Object)this.z.modid, (Object)Thread.currentThread().getName());
            this.z.configManager.onReload();
            this.z.loadBus.fire(new ForgeZConfigChange());
            if (this.z.side == ZetaSide.CLIENT) {
                oldState = this.state.getAndSet(2);
                this.z.log.info("{}'s config is now ready to accept filewatcher changes", (Object)this.z.modid);
            } else {
                oldState = this.state.getAndSet(1);
                this.z.log.info("Waiting for server start before accepting filewatcher changes to {}'s config", (Object)this.z.modid);
            }
            if (oldState != 0) {
                this.z.log.warn("Common setup: {}'s config was previously in state '{}'... weird, but trying to continue. Report this.", (Object)this.z.modid, (Object)ConfigEventDispatcher.fmtState(oldState));
            }
        });
    }

    public void serverAboutToStart(ServerAboutToStartEvent e) {
        if (this.z.side == ZetaSide.SERVER) {
            this.z.log.info("Server starting, accepting filewatcher changes for {}'s config", (Object)this.z.modid);
            int oldState = this.state.getAndSet(2);
            if (oldState != 1) {
                this.z.log.warn("Server start: {}'s config was previously in state '{}'... weird, but trying to continue. Report this.", (Object)this.z.modid, (Object)ConfigEventDispatcher.fmtState(oldState));
            }
        }
    }

    public void modConfigReloading(ModConfigEvent.Reloading event) {
        String modid = this.z.modid;
        if (!event.getConfig().getModId().equals(modid)) {
            return;
        }
        if (this.z.configManager == null || this.z.configInternals == null) {
            this.z.log.info("Ignoring request to refresh {}'s config WAY too early", (Object)this.z.modid);
            return;
        }
        this.z.log.info("About to refresh {}'s config, looking for better thread than '{}'...", (Object)this.z.modid, (Object)Thread.currentThread().getName());
        this.z.proxy.tryToExecuteOnMainThread(() -> {
            int oldState = this.state.compareAndExchange(2, 3);
            if (oldState != 2) {
                this.z.log.info("{}'s config is '{}', ignoring config refresh. Current thread: {}", (Object)this.z.modid, (Object)ConfigEventDispatcher.fmtState(oldState), (Object)Thread.currentThread().getName());
                return;
            }
            this.z.log.info("Refreshing {}'s config on thread '{}'", (Object)this.z.modid, (Object)Thread.currentThread().getName());
            try {
                this.z.configManager.onReload();
                this.z.loadBus.fire(new ForgeZConfigChange());
            }
            finally {
                this.z.log.info("All done refreshing {}'s config", (Object)this.z.modid);
                this.state.setRelease(2);
            }
        });
    }

    private static String fmtState(int state) {
        return switch (state) {
            case 0 -> "BEFORE_INIT";
            case 1 -> "WAITING_FOR_SERVER_START";
            case 2 -> "ACCEPT_FILE_RELOADS";
            case 3 -> "BUSY";
            default -> "weird unknown state " + state + "???";
        };
    }
}

