/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.module.IDisableable;

public class CreativeTabManager {
    private static final Object MUTEX = new Object();
    private static final Map<ResourceKey<CreativeModeTab>, CreativeTabAdditions> additions = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabAdditions>();
    private static final Multimap<ItemLike, ResourceKey<CreativeModeTab>> mappedItems = HashMultimap.create();
    private static boolean daisyChainMode = false;
    private static ItemSet daisyChainedSet = null;

    public static void daisyChain() {
        daisyChainMode = true;
        daisyChainedSet = null;
    }

    public static void endDaisyChain() {
        daisyChainMode = false;
        daisyChainedSet = null;
    }

    public static void addToCreativeTab(ResourceKey<CreativeModeTab> tab, ItemLike item) {
        if (daisyChainMode) {
            if (daisyChainedSet == null) {
                throw new IllegalArgumentException("Must start daisy chain with addToCreativeTabNextTo");
            }
            CreativeTabManager.addToDaisyChain(item);
        } else {
            CreativeTabManager.getForTab(tab).appendToEnd.add(item);
        }
        mappedItems.put((Object)item, tab);
    }

    public static void addToCreativeTabNextTo(ResourceKey<CreativeModeTab> tab, ItemLike item, ItemLike target, boolean behind) {
        tab = CreativeTabManager.guessTab(target, tab);
        CreativeTabAdditions additions = CreativeTabManager.getForTab(tab);
        Map<ItemSet, ItemLike> map = behind ? additions.appendBehind : additions.appendInFront;
        ItemSet toAdd = null;
        if (daisyChainMode) {
            boolean newSet = daisyChainedSet == null;
            ItemSet set = CreativeTabManager.addToDaisyChain(item);
            if (newSet) {
                toAdd = set;
            }
        } else {
            toAdd = new ItemSet(item);
        }
        if (toAdd != null) {
            map.put(toAdd, target);
        }
        mappedItems.put((Object)item, tab);
    }

    private static ItemSet addToDaisyChain(ItemLike item) {
        if (daisyChainMode && daisyChainedSet != null) {
            CreativeTabManager.daisyChainedSet.items.add(item);
            return daisyChainedSet;
        }
        ItemSet set = new ItemSet(item);
        if (daisyChainMode) {
            daisyChainedSet = set;
        }
        return set;
    }

    private static ResourceKey<CreativeModeTab> guessTab(ItemLike parent, ResourceKey<CreativeModeTab> tab) {
        return parent != null && mappedItems.containsKey((Object)parent) ? (ResourceKey)mappedItems.get((Object)parent).iterator().next() : tab;
    }

    private static CreativeTabAdditions getForTab(ResourceKey<CreativeModeTab> tab) {
        return additions.computeIfAbsent(tab, tabRk -> new CreativeTabAdditions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        Object object = MUTEX;
        synchronized (object) {
            ResourceKey tabKey = event.getTabKey();
            if (additions.containsKey(tabKey)) {
                CreativeTabAdditions add = additions.get(tabKey);
                for (ItemLike item : add.appendToEnd) {
                    CreativeTabManager.acceptItem(event, item);
                }
                if (ZetaGeneralConfig.forceCreativeTabAppends) {
                    for (ItemSet itemset : add.appendInFront.keySet()) {
                        for (ItemLike item : itemset.items) {
                            CreativeTabManager.acceptItem(event, item);
                        }
                    }
                    for (ItemSet itemset : add.appendBehind.keySet()) {
                        for (ItemLike item : itemset.items) {
                            CreativeTabManager.acceptItem(event, item);
                        }
                    }
                    return;
                }
                LinkedHashMap<ItemSet, ItemLike> front = new LinkedHashMap<ItemSet, ItemLike>(add.appendInFront);
                LinkedHashMap<ItemSet, ItemLike> behind = new LinkedHashMap<ItemSet, ItemLike>(add.appendBehind);
                int maxFails = 100;
                int logThreshold = 90;
                int failedAttempts = 0;
                while (!front.isEmpty() && !behind.isEmpty() || failedAttempts < 100) {
                    if (!front.isEmpty()) {
                        int n = failedAttempts = CreativeTabManager.addItems(event, front, false, failedAttempts > 90) ? failedAttempts : failedAttempts + 1;
                    }
                    if (!behind.isEmpty()) {
                        int n = failedAttempts = CreativeTabManager.addItems(event, behind, true, failedAttempts > 90) ? failedAttempts : failedAttempts + 1;
                    }
                    if (!front.isEmpty() || !behind.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    private static boolean addItems(BuildCreativeModeTabContentsEvent event, Map<ItemSet, ItemLike> itemsMap, boolean insertAfter, boolean log) {
        Set<ItemSet> collection = itemsMap.keySet();
        ItemSet itemsToAdd = (ItemSet)collection.iterator().next();
        ItemLike firstSetItem = itemsToAdd.items.getFirst();
        ItemLike target = itemsMap.get(itemsToAdd);
        CreativeTabManager.logVerbose(() -> "target is " + String.valueOf(target));
        itemsMap.remove(itemsToAdd);
        if (log) {
            ZetaMod.LOGGER.error("Creative tab loop found when adding {} next to {}", (Object)firstSetItem, (Object)target);
            ZetaMod.LOGGER.error("For more info enable Creative Verbose Logging in the Zeta config, or set Force Creative Tab Appends to true to disable this behavior");
        }
        if (!CreativeTabManager.isItemEnabled(firstSetItem) || target == null) {
            return true;
        }
        ItemStack targetStack = new ItemStack(target);
        for (ItemLike item : itemsToAdd.items) {
            if (!CreativeTabManager.isItemEnabled(item)) continue;
            List<ItemStack> stacksToAdd = List.of(new ItemStack(item));
            if (item instanceof AppendsUniquely) {
                AppendsUniquely au = (AppendsUniquely)item;
                stacksToAdd = au.appendItemsToCreativeTab();
            }
            if (!insertAfter) {
                Collections.reverse(stacksToAdd);
            }
            for (ItemStack addStack : stacksToAdd) {
                if (insertAfter) {
                    try {
                        event.insertAfter(targetStack, addStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        continue;
                    }
                    catch (IllegalArgumentException exception) {
                        CreativeTabManager.logVerbose(exception::getMessage);
                        itemsMap.put(itemsToAdd, target);
                        return false;
                    }
                }
                try {
                    event.insertBefore(targetStack, addStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
                catch (IllegalArgumentException exception) {
                    CreativeTabManager.logVerbose(exception::getMessage);
                    itemsMap.put(itemsToAdd, target);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isItemEnabled(ItemLike item) {
        IDisableable id;
        return !(item instanceof IDisableable) || (id = (IDisableable)item).isEnabled();
    }

    private static void acceptItem(BuildCreativeModeTabContentsEvent event, ItemLike item) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            event.acceptAll(au.appendItemsToCreativeTab());
        } else {
            event.accept(item);
        }
    }

    private static void logVerbose(Supplier<String> s) {
        if (ZetaGeneralConfig.enableCreativeVerboseLogging) {
            ZetaMod.LOGGER.warn(s.get());
        }
    }

    private static class ItemSet {
        List<ItemLike> items = new ArrayList<ItemLike>();

        public ItemSet(ItemLike item) {
            this.items.add(item);
        }
    }

    private static class CreativeTabAdditions {
        private final List<ItemLike> appendToEnd = new ArrayList<ItemLike>();
        private final Map<ItemSet, ItemLike> appendInFront = new LinkedHashMap<ItemSet, ItemLike>();
        private final Map<ItemSet, ItemLike> appendBehind = new LinkedHashMap<ItemSet, ItemLike>();

        private CreativeTabAdditions() {
        }
    }

    public static interface AppendsUniquely
    extends ItemLike {
        public List<ItemStack> appendItemsToCreativeTab();
    }
}

