/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.item;

import java.util.function.BooleanSupplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;

public abstract class ZetaArrowItem
extends ArrowItem
implements IZetaItem {
    @Nullable
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public ZetaArrowItem(String name, @Nullable ZetaModule module) {
        super(new Item.Properties());
        this.module = module;
        if (module == null) {
            return;
        }
        module.zeta().registry.registerItem((Item)this, name);
        CreativeTabManager.addToCreativeTab((ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT, (ItemLike)this);
    }

    @Override
    public ZetaArrowItem setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    public static class Impl
    extends ZetaArrowItem {
        private final ArrowItemCreator itemCreator;
        private final ArrowProjectileCreator projectileCreator;

        public Impl(String name, ZetaModule module, ArrowItemCreator itemCreator, ArrowProjectileCreator projectileCreator) {
            super(name, module);
            this.itemCreator = itemCreator;
            this.projectileCreator = projectileCreator;
        }

        public AbstractArrow createArrow(Level level, ItemStack pickupStack, LivingEntity shooter, @Nullable ItemStack weapon) {
            return this.itemCreator.createArrow(level, shooter, pickupStack, weapon);
        }

        public Projectile asProjectile(Level level, Position position, @Nullable ItemStack pickupStack, Direction direction) {
            return this.projectileCreator.createProjectile(level, position.x(), position.y(), position.z(), pickupStack, null);
        }

        public static interface ArrowItemCreator {
            public AbstractArrow createArrow(Level var1, LivingEntity var2, ItemStack var3, @Nullable ItemStack var4);
        }

        public static interface ArrowProjectileCreator {
            public Projectile createProjectile(Level var1, double var2, double var4, double var6, ItemStack var8, @Nullable ItemStack var9);
        }
    }
}

