/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.violetmoon.zeta.config.ConfigFlagManager;

public class SyncedFlagHandler {
    private static ConfigFlagManager flagManager;
    private static List<String> sortedFlags;
    private static final WeakHashMap<PacketListener, Set<String>> flagsFromServer;
    private static final WeakHashMap<ServerPlayer, Set<String>> flagsFromPlayers;

    public static void setupFlagManager(ConfigFlagManager manager) {
        if (manager != null) {
            flagManager = manager;
            sortedFlags = manager.getAllFlags().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        }
    }

    public static BitSet compileFlagInfo() {
        BitSet set = new BitSet();
        int i = 0;
        for (String flag : sortedFlags) {
            set.set(i++, flagManager.getFlag(flag));
        }
        return set;
    }

    public static int expectedLength() {
        return sortedFlags.size();
    }

    public static int expectedHash() {
        return sortedFlags.hashCode();
    }

    private static Set<String> decodeFlags(BitSet bitSet) {
        HashSet<String> enabledFlags = new HashSet<String>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            enabledFlags.add(sortedFlags.get(i));
            i = bitSet.nextSetBit(i + 1);
        }
        return enabledFlags;
    }

    public static void receiveFlagInfoFromPlayer(ServerPlayer player, BitSet bitSet) {
        flagsFromPlayers.put(player, SyncedFlagHandler.decodeFlags(bitSet));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveFlagInfoFromServer(BitSet bitSet) {
        flagsFromServer.put((PacketListener)Minecraft.getInstance().getConnection(), SyncedFlagHandler.decodeFlags(bitSet));
    }

    public static boolean getFlagForPlayer(ServerPlayer player, String flag) {
        Set<String> enabledFlags = flagsFromPlayers.get(player);
        if (enabledFlags == null) {
            return flagManager.getFlag(flag);
        }
        return enabledFlags.contains(flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean getFlagForServer(String flag) {
        for (PacketListener listener : flagsFromServer.keySet()) {
            Set<String> enabledFlags = flagsFromServer.get(listener);
            if (enabledFlags == null) continue;
            return enabledFlags.contains(flag);
        }
        return flagManager.getFlag(flag);
    }

    static {
        flagsFromServer = new WeakHashMap();
        flagsFromPlayers = new WeakHashMap();
    }
}

