/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.event.load;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.client.key.PredicatedKeyBinding;
import org.violetmoon.zeta.client.key.SortedKeyBinding;
import org.violetmoon.zeta.client.key.SortedPredicatedKeyBinding;
import org.violetmoon.zeta.event.bus.IZetaLoadEvent;

public interface ZKeyMapping
extends IZetaLoadEvent {
    public KeyMapping register(KeyMapping var1);

    default public KeyMapping init(String id, @Nullable String key, String group) {
        return this.register(new KeyMapping(id, InputConstants.Type.KEYSYM, this.getKeyCode(key, InputConstants.Type.KEYSYM), group));
    }

    default public KeyMapping init(String id, @Nullable String key, String group, int sortPriority) {
        return this.register(new SortedKeyBinding(id, InputConstants.Type.KEYSYM, this.getKeyCode(key, InputConstants.Type.KEYSYM), group, sortPriority));
    }

    default public KeyMapping init(String id, @Nullable String key, String group, Predicate<InputConstants.Key> allowed) {
        return this.register(new PredicatedKeyBinding(id, InputConstants.Type.KEYSYM, this.getKeyCode(key, InputConstants.Type.KEYSYM), group, allowed));
    }

    default public KeyMapping init(String id, @Nullable String key, String group, int sortPriority, Predicate<InputConstants.Key> allowed) {
        return this.register(new SortedPredicatedKeyBinding(id, InputConstants.Type.KEYSYM, this.getKeyCode(key, InputConstants.Type.KEYSYM), group, sortPriority, allowed));
    }

    default public KeyMapping initMouse(String id, int key, String group) {
        return this.register(new KeyMapping(id, InputConstants.Type.MOUSE, this.getKeyCode(Integer.toString(key), InputConstants.Type.MOUSE), group));
    }

    default public KeyMapping initMouse(String id, int key, String group, int sortPriority) {
        return this.register(new SortedKeyBinding(id, InputConstants.Type.MOUSE, this.getKeyCode(Integer.toString(key), InputConstants.Type.MOUSE), group, sortPriority));
    }

    default public KeyMapping initMouse(String id, int key, String group, Predicate<InputConstants.Key> allowed) {
        return this.register(new PredicatedKeyBinding(id, InputConstants.Type.MOUSE, this.getKeyCode(Integer.toString(key), InputConstants.Type.MOUSE), group, allowed));
    }

    default public KeyMapping initMouse(String id, int key, String group, int sortPriority, Predicate<InputConstants.Key> allowed) {
        return this.register(new SortedPredicatedKeyBinding(id, InputConstants.Type.MOUSE, this.getKeyCode(Integer.toString(key), InputConstants.Type.MOUSE), group, sortPriority, allowed));
    }

    default public String getKeyPrefix(InputConstants.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case InputConstants.Type.MOUSE -> "key.mouse.";
            case InputConstants.Type.KEYSYM -> "key.keyboard.";
            case InputConstants.Type.SCANCODE -> "scancode.";
        };
    }

    default public int getKeyCode(@Nullable String key, InputConstants.Type type) {
        return (key == null ? InputConstants.UNKNOWN : InputConstants.getKey((String)(this.getKeyPrefix(type) + key))).getValue();
    }
}

