/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;

public class ScrollableWidgetList<S extends Screen, E extends Entry<E>>
extends ObjectSelectionList<E> {
    public final S parent;

    public ScrollableWidgetList(S parent) {
        super(Minecraft.getInstance(), ((Screen)parent).width, ((Screen)parent).height - 80, 40, 30);
        this.parent = parent;
    }

    public int addEntry(E entry) {
        return super.addEntry(entry);
    }

    public void replaceEntries(Collection<E> newEntries) {
        super.replaceEntries(newEntries);
    }

    public void scroll2(int amt) {
        this.setScrollAmount(this.getScrollAmount() + (double)amt);
    }

    public void ensureVisible2(int index) {
        int k;
        int i = this.getRowTop(index);
        int j = i - this.getY() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll2(j);
        }
        if ((k = this.getBottom() - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll2(-k);
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    public void forEachWidgetWrapper(Consumer<WidgetWrapper> action) {
        this.children().forEach(e -> e.children.forEach(action));
    }

    public void addChildWidgets(Consumer<AbstractWidget> addRenderableWidget, Consumer<AbstractWidget> addWidget) {
        this.forEachWidgetWrapper(w -> {
            if (w.widget instanceof Button) {
                addRenderableWidget.accept(w.widget);
            } else {
                addWidget.accept(w.widget);
            }
        });
    }

    public void removeChildWidgets(Consumer<AbstractWidget> removeWidget) {
        this.forEachWidgetWrapper(w -> removeWidget.accept(w.widget));
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.forEachWidgetWrapper(w -> {
            w.widget.visible = false;
            w.wasOnScreen = false;
        });
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void reenableVisibleWidgets() {
        this.forEachWidgetWrapper(w -> {
            if (w.wasOnScreen) {
                w.widget.visible = true;
            }
        });
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ObjectSelectionList.Entry<E> {
        public List<WidgetWrapper> children = new ArrayList<WidgetWrapper>();

        public void addScrollingWidget(AbstractWidget e) {
            this.children.add(new WidgetWrapper(e));
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.children.forEach(c -> {
                c.updatePosition(rowLeft, rowTop);
                c.wasOnScreen = true;
                c.widget.visible = true;
                c.widget.render(guiGraphics, mouseX, mouseY, partialTicks);
                c.widget.visible = false;
            });
        }

        public void drawBackground(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
            if (index % 2 == 0) {
                guiGraphics.fill(rowLeft, rowTop, rowLeft + rowWidth, rowTop + rowHeight, 0x66000000);
            }
            if (hovered) {
                guiGraphics.fill(rowLeft, rowTop, rowLeft + 1, rowTop + rowHeight, -1);
                guiGraphics.fill(rowLeft + rowWidth - 1, rowTop, rowLeft + rowWidth, rowTop + rowHeight, -1);
                guiGraphics.fill(rowLeft, rowTop, rowLeft + rowWidth, rowTop + 1, -1);
                guiGraphics.fill(rowLeft, rowTop + rowHeight - 1, rowLeft + rowWidth, rowTop + rowHeight, -1);
            }
        }
    }

    public static class WidgetWrapper {
        public final AbstractWidget widget;
        public final int relativeX;
        public final int relativeY;
        public boolean wasOnScreen = false;

        public WidgetWrapper(AbstractWidget widget) {
            this.widget = widget;
            this.relativeX = widget.getX();
            this.relativeY = widget.getY();
        }

        public void updatePosition(int currX, int currY) {
            this.widget.setX(currX + this.relativeX);
            this.widget.setY(currY + this.relativeY);
            this.widget.visible = true;
        }
    }
}

