/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import org.violetmoon.zeta.api.IMutableAdvancement;

public class MutableAdvancement
implements IMutableAdvancement {
    Advancement advancement;
    public Map<String, Criterion<?>> criteria;
    public List<List<String>> requirements;

    public MutableAdvancement(Advancement advancement) {
        this.advancement = advancement;
        this.mutabilize();
    }

    @Override
    public void addRequiredCriterion(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        this.requirements.add(Lists.newArrayList((Object[])new String[]{name}));
    }

    @Override
    public void addOrCriterion(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        this.requirements.getFirst().add(name);
    }

    @Override
    public void removeCriterion(String name) {
        this.criteria.remove(name);
    }

    @Override
    public void replaceCriterion(String name, Criterion<?> criterion) {
        this.criteria.replace(name, criterion);
    }

    @Override
    public Criterion<?> getCriterion(String title) {
        return this.criteria.get(title);
    }

    private void mutabilize() {
        this.criteria = Maps.newHashMap((Map)this.advancement.criteria());
        this.requirements = new ArrayList<List<String>>();
        AdvancementRequirements advReq = this.advancement.requirements();
        for (List requirement : advReq.requirements()) {
            ArrayList replcRequirement = new ArrayList();
            replcRequirement.addAll(requirement);
            this.requirements.add(replcRequirement);
        }
    }

    public void commit() {
        this.advancement = new Advancement(this.advancement.parent(), this.advancement.display(), this.advancement.rewards(), (Map)ImmutableMap.copyOf(this.criteria), new AdvancementRequirements(this.requirements), this.advancement.sendsTelemetryEvent(), this.advancement.name());
    }
}

