/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.multipart.api.part.render.PartRenderer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.transmission.client.WireModelRenderer;
import mrtjp.projectred.transmission.part.BaseFaceWirePart;
import mrtjp.projectred.transmission.part.BundledCablePart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.BlockAndTintGetter;

public class FaceWirePartRenderer
implements PartRenderer<BaseFaceWirePart> {
    public static final FaceWirePartRenderer INSTANCE = new FaceWirePartRenderer();

    public void renderStatic(BaseFaceWirePart part, @Nullable RenderType layer, CCRenderState ccrs) {
        if (layer == null || layer == RenderType.solid() && this.useStaticRenderer(part)) {
            ccrs.setBrightness((BlockAndTintGetter)part.level(), part.pos());
            WireModelRenderer.render(ccrs, part);
        }
    }

    public void renderDynamic(BaseFaceWirePart part, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        if (!this.useStaticRenderer(part)) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.brightness = packedLight;
            ccrs.overlay = packedOverlay;
            ccrs.bind((VertexConsumer)new TransformingVertexConsumer(buffers.getBuffer(RenderType.solid()), mStack), DefaultVertexFormat.BLOCK);
            WireModelRenderer.render(ccrs, part);
        }
    }

    private boolean useStaticRenderer(BaseFaceWirePart part) {
        if (part instanceof BundledCablePart) {
            return true;
        }
        return Configurator.staticWires;
    }
}

