/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartMap;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ConnectionsLib {
    @Nullable
    public static MultiPart getFaceCornerPart(Level world, BlockPos pos, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        BlockPos pos2 = pos.relative(Direction.values()[absDir]).relative(Direction.values()[side]);
        return BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos2, (int)(absDir ^ 1));
    }

    @Nullable
    public static MultiPart getFaceStraightPart(Level world, BlockPos pos, int side, int r) {
        BlockPos pos2 = pos.relative(Direction.values()[r]);
        return BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos2, (int)side);
    }

    @Nullable
    public static MultiPart getFaceInternalPart(Level world, BlockPos pos, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        return BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos, (int)absDir);
    }

    @Nullable
    public static MultiPart getCenterPart(Level world, BlockPos pos) {
        return BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos, (int)6);
    }

    @Nullable
    public static MultiPart getFaceInternalPart(TileMultipart tile, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        return tile.getSlottedPart(absDir);
    }

    @Nullable
    public static MultiPart getCenterPart(TileMultipart tile) {
        return tile.getSlottedPart(6);
    }

    @Nullable
    public static IConnectable getFaceCornerConnectable(Level world, BlockPos pos, int side, int r) {
        MultiPart part = ConnectionsLib.getFaceCornerPart(world, pos, side, r);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getFaceStraightConnectable(Level world, BlockPos pos, int side, int r) {
        MultiPart part = ConnectionsLib.getFaceStraightPart(world, pos, side, r);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getFaceInternalConnectable(Level world, BlockPos pos, int side, int r) {
        MultiPart part = ConnectionsLib.getFaceInternalPart(world, pos, side, r);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getFaceInternalConnectable(TileMultipart tile, int side, int r) {
        MultiPart part = ConnectionsLib.getFaceInternalPart(tile, side, r);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getCenterConnectable(Level world, BlockPos pos) {
        MultiPart part = ConnectionsLib.getCenterPart(world, pos);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getCenterConnectable(TileMultipart tile) {
        MultiPart part = ConnectionsLib.getCenterPart(tile);
        if (part instanceof IConnectable) {
            return (IConnectable)part;
        }
        return null;
    }

    @Nullable
    public static IConnectable getCenterConnectable(BlockEntity tile) {
        if (tile instanceof TileMultipart) {
            return ConnectionsLib.getCenterConnectable((TileMultipart)tile);
        }
        return null;
    }

    public static boolean outsideCornerEdgeOpen(Level world, BlockPos pos, int side, int r) {
        int dir = Rotation.rotateSide((int)side, (int)r);
        BlockPos straightPos = pos.relative(Direction.values()[dir]);
        if (world.isEmptyBlock(straightPos)) {
            return true;
        }
        int perpSide = dir ^ 1;
        TileMultipart t = BlockMultipart.getTile((BlockGetter)world, (BlockPos)straightPos);
        if (t == null) {
            return false;
        }
        return t.getSlottedPart(perpSide) == null && t.getSlottedPart(side) == null && t.getSlottedPart(PartMap.edgeBetween((int)perpSide, (int)side)) == null;
    }

    public static boolean insideCornerEdgeOpen(Level world, BlockPos pos, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        return BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos, (int)PartMap.edgeBetween((int)absDir, (int)side)) == null;
    }

    public static boolean connectFaceCorner(IConnectable source, int side, int r, @Nullable IConnectable target) {
        if (target != null) {
            int dir = Rotation.rotateSide((int)side, (int)r);
            int otherRotation = Rotation.rotationTo((int)(dir ^ 1), (int)(side ^ 1));
            int otherSide = dir ^ 1;
            return target.connectCorner(source, otherRotation, otherSide);
        }
        return false;
    }

    public static boolean connectFaceStraight(IConnectable source, int side, int r, @Nullable IConnectable target) {
        if (target != null) {
            int otherRotation = (r + 2) % 4;
            int otherSide = side;
            return target.connectStraight(source, otherRotation, otherSide);
        }
        return false;
    }

    public static boolean connectFaceInternal(IConnectable source, int side, int r, @Nullable IConnectable target) {
        if (target != null) {
            int dir = Rotation.rotateSide((int)side, (int)r);
            int otherRotation = Rotation.rotationTo((int)dir, (int)side);
            return target.connectInternal(source, otherRotation);
        }
        return false;
    }
}

