/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.part.hollow.HollowMicroblockPart;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.SlottedPart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import javax.annotation.Nullable;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.illumination.MultipartLightProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultipartLightPart
extends BaseMultipart
implements SlottedPart,
NormalOcclusionPart,
RedstonePart,
IconHitEffectsPart {
    private final MultipartType<?> type;
    private final MultipartLightProperties properties;
    private final int color;
    private final boolean inverted;
    protected boolean powered = false;
    protected int side = 0;

    public MultipartLightPart(MultipartType<?> type, MultipartLightProperties properties, int color, boolean inverted) {
        this.type = type;
        this.properties = properties;
        this.color = color;
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getSide() {
        return this.side;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isLightOn() {
        return this.powered != this.inverted;
    }

    public MultipartLightProperties getProperties() {
        return this.properties;
    }

    public void preparePlacement(int side) {
        this.side = side;
    }

    public void save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putBoolean("pow", this.powered);
        tag.putByte("side", (byte)this.side);
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.powered = tag.getBoolean("pow");
        this.side = tag.getByte("side") & 0xFF;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.side).writeBoolean(this.powered);
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readUByte();
        this.powered = packet.readBoolean();
    }

    public void readUpdate(MCDataInput packet) {
        this.readDesc(packet);
        this.updateRender();
    }

    public void onNeighborBlockChanged(BlockPos from) {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onPartChanged(@Nullable MultiPart part) {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onAdded() {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(true);
    }

    public int getLightEmission() {
        return this.isInverted() != this.powered ? 15 : 0;
    }

    public Cuboid6 getBounds() {
        return this.properties.getBounds(this.side);
    }

    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return this.getBrokenIcon(this.side);
    }

    public TextureAtlasSprite getBrokenIcon(int side) {
        return this.properties.getIcon(this.color);
    }

    private ItemStack getItem() {
        return this.properties.makeStack(this.color, this.inverted);
    }

    private boolean checkSupport() {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.properties.canFloat()) {
            return false;
        }
        BlockPos bc = this.pos().relative(Direction.values()[this.side]);
        if (MultipartLightPart.canPlaceLight(this.level(), bc, Direction.values()[this.side ^ 1])) {
            return false;
        }
        TileMultipart.dropItem((ItemStack)this.getItem(), (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
        this.tile().remPart((MultiPart)this);
        return true;
    }

    private boolean checkPower() {
        for (int s = 0; s < 6; ++s) {
            if (s == (this.side ^ 1) || RedstoneInteractions.getPowerTo((MultiPart)this, (int)s) <= 0) continue;
            return true;
        }
        return false;
    }

    private void updateState(boolean forceRender) {
        boolean updated = false;
        if (!this.level().isClientSide) {
            boolean oldPower = this.powered;
            this.powered = this.checkPower();
            if (oldPower != this.powered) {
                updated = true;
                this.updateRender();
            }
        }
        if (forceRender && !updated) {
            this.updateRender();
        }
    }

    private void updateRender() {
        if (!this.level().isClientSide) {
            this.sendUpdate(this::writeDesc);
        }
        this.tile().recalcLight(false, true);
        this.tile().markRender();
    }

    public VoxelShape getShape(CollisionContext context) {
        return this.properties.getShape(this.side);
    }

    public VoxelShape getOcclusionShape() {
        return this.getShape(CollisionContext.empty());
    }

    public VoxelShape getBlockSupportShape() {
        return Shapes.empty();
    }

    public MultipartType<?> getType() {
        return this.type;
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        return 0.06666667f;
    }

    public int getSlotMask() {
        return 64;
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.getItem());
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getItem();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return SoundType.GLASS;
    }

    public static boolean canPlaceLight(Level world, BlockPos pos, Direction side) {
        if (PlacementLib.canPlaceLight((Level)world, (BlockPos)pos, (Direction)side)) {
            return true;
        }
        MultiPart part = BlockMultipart.getPart((BlockGetter)world, (BlockPos)pos, (int)side.ordinal());
        return part instanceof HollowMicroblockPart;
    }
}

