/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.init;

import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.render.PartRenderer;
import java.util.Objects;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.client.IllumarLampBlockEntityRenderer;
import mrtjp.projectred.illumination.client.IllumarLampItemRenderer;
import mrtjp.projectred.illumination.client.IllumarSmartLampBlockEntityRenderer;
import mrtjp.projectred.illumination.client.IllumarSmartLampItemRenderer;
import mrtjp.projectred.illumination.client.MultipartLightPartRenderer;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

public class IlluminationClientInit {
    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(IlluminationClientInit::clientSetup);
        modEventBus.addListener(IlluminationClientInit::onModelBake);
        for (MultipartLightType type : MultipartLightType.values()) {
            modEventBus.addListener(type.getProperties()::onTextureStitchEvent);
        }
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        for (BlockLightType blockLightType : BlockLightType.values()) {
            for (int color = 0; color < 16; ++color) {
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast(blockLightType.getTileEntityType(color, false))), c -> IllumarLampBlockEntityRenderer.INSTANCE);
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast(blockLightType.getTileEntityType(color, true))), c -> IllumarLampBlockEntityRenderer.INSTANCE);
            }
        }
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast(IlluminationBlocks.ILLUMAR_SMART_LAMP_BLOCK_ENTITY.get())), c -> IllumarSmartLampBlockEntityRenderer.INSTANCE);
        for (Enum enum_ : MultipartLightType.values()) {
            for (int colour = 0; colour < 16; ++colour) {
                MultipartClientRegistry.register(((MultipartLightType)enum_).getPartType(colour, false), (PartRenderer)MultipartLightPartRenderer.INSTANCE);
                MultipartClientRegistry.register(((MultipartLightType)enum_).getPartType(colour, true), (PartRenderer)MultipartLightPartRenderer.INSTANCE);
            }
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        for (int color = 0; color < 16; ++color) {
            ResourceLocation blockRL = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)BlockLightType.ILLUMAR_LAMP.getBlock(color, true)));
            BakedModel litModel = (BakedModel)event.getModels().get(new ModelResourceLocation(blockRL, "lit=true"));
            event.getModels().put(new ModelResourceLocation(blockRL, "inventory"), new IllumarLampItemRenderer(litModel));
        }
        ResourceLocation smartLampRl = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)IlluminationBlocks.ILLUMAR_SMART_LAMP.get()));
        BakedModel smartLampModel = (BakedModel)event.getModels().get(new ModelResourceLocation(smartLampRl, "level=15,side=0"));
        event.getModels().put(new ModelResourceLocation(smartLampRl, "inventory"), new IllumarSmartLampItemRenderer(smartLampModel));
    }
}

