/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.multipart.api.MultipartType;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.illumination.data.IlluminationBlockStateModelProvider;
import mrtjp.projectred.illumination.data.IlluminationCreativeModeTabs;
import mrtjp.projectred.illumination.data.IlluminationItemModelProvider;
import mrtjp.projectred.illumination.data.IlluminationLanguageProvider;
import mrtjp.projectred.illumination.data.IlluminationLootTableProvider;
import mrtjp.projectred.illumination.data.IlluminationRecipeProvider;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import mrtjp.projectred.illumination.init.IlluminationClientInit;
import mrtjp.projectred.illumination.init.IlluminationMicroMaterials;
import mrtjp.projectred.illumination.init.IlluminationParts;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_illumination")
public class ProjectRedIllumination {
    public static final String MOD_ID = "projectred_illumination";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_illumination");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"projectred_illumination");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_illumination");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"projectred_illumination");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_illumination");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_illumination");
    @Nullable
    private static ModContainer container;

    public ProjectRedIllumination(ModContainer container, IEventBus modEventBus) {
        ProjectRedIllumination.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        if (FMLEnvironment.dist.isClient()) {
            IlluminationClientInit.init(modEventBus);
        }
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        PART_TYPES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        modEventBus.register((Object)new IlluminationMicroMaterials());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new IlluminationBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new IlluminationItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new IlluminationLanguageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new IlluminationLootTableProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new IlluminationRecipeProvider(provider, output));
    }

    static {
        IlluminationBlocks.register();
        IlluminationParts.register();
        IlluminationMicroMaterials.register();
        IlluminationCreativeModeTabs.register();
    }
}

