/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.inventory.container.PlottingTableMenu;
import mrtjp.projectred.fabrication.item.BlankPhotomaskItem;
import mrtjp.projectred.fabrication.item.ICBlueprintItem;
import mrtjp.projectred.fabrication.item.component.BlueprintDataComponent;
import mrtjp.projectred.fabrication.tile.FabricationMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class PlottingTableBlockEntity
extends FabricationMachineBlockEntity {
    private final BaseContainer inventory = new BaseContainer(this, 3){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ICBlueprintItem;
                case 1 -> stack.getItem() instanceof BlankPhotomaskItem;
                default -> false;
            };
        }
    };

    public PlottingTableBlockEntity(BlockPos pos, BlockState state) {
        super(FabricationBlocks.PLOTTING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.inventory.addListener(this::onInventoryChanged);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        this.inventory.saveTo(tag, "inventory", lookupProvider);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.inventory.loadFrom(tag, "inventory", lookupProvider);
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new PlottingTableMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        PlottingTableBlockEntity.dropInventory((Container)this.inventory, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    private void onInventoryChanged(Container inventory) {
        this.cancelWorkIfNeeded();
        this.setChanged();
    }

    @Override
    protected boolean canStartWork() {
        ItemStack slot0 = this.inventory.getItem(0);
        ItemStack slot1 = this.inventory.getItem(1);
        if (slot0.isEmpty() || slot1.isEmpty()) {
            return false;
        }
        if (!(slot0.getItem() instanceof ICBlueprintItem)) {
            return false;
        }
        if (!(slot1.getItem() instanceof BlankPhotomaskItem)) {
            return false;
        }
        BlueprintDataComponent component = BlueprintDataComponent.getComponent(slot0);
        if (component == null || !component.getICData().canFabricate()) {
            return false;
        }
        return this.inventory.getItem(2).isEmpty();
    }

    @Override
    protected int startWork() {
        return 200;
    }

    @Override
    protected int tickWork(int remainingWork) {
        if (this.canConductorWork()) {
            this.conductor.applyPower(-100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        ItemStack output = ICBlueprintItem.createPhotomaskStack(this.inventory.getItem(0));
        this.inventory.setItem(2, output);
        this.inventory.removeItem(1, 1);
    }
}

